/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.sqlite.dal.SQLiteHelper;
import org.gvsig.sqlite.dal.geopackage.GeopackageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeopackageSpatialRefSys {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GeopackageSpatialRefSys.class);
    private String srs_name;
    private int srs_id;
    private String organization;
    private int organization_coordsys_id;
    private String definition;
    private String description;

    public GeopackageSpatialRefSys(IProjection projection) {
        if (!this.search(projection)) {
            if (projection.isProjected()) {
                this.definition = "undefined";
                this.description = "undefined cartesian coordinate reference system";
                this.organization = "NONE";
                this.organization_coordsys_id = -1;
                this.srs_id = -1;
                this.srs_name = "Undefined cartesian SRS";
            } else {
                this.definition = "undefined";
                this.description = "undefined geographic coordinate reference system";
                this.organization = "NONE";
                this.organization_coordsys_id = 0;
                this.srs_id = 0;
                this.srs_name = "Undefined geographic SRS";
            }
        }
    }

    private boolean search(IProjection projection) {
        String abrev = "UNKNOWN";
        try {
            abrev = projection.getAbrev();
            String[] ss = abrev.split(":");
            String authority = ss[0];
            int authorityCode = NumberUtils.toInt((String)ss[1], (int)Integer.MIN_VALUE);
            if (authorityCode == Integer.MIN_VALUE) {
                return false;
            }
            String resourceName = "/org/gvsig/sqlite/dal/epsg_crs_wkt/" + authority + "-CRS-" + authorityCode + ".wkt";
            String wkt = IOUtils.toString((URL)this.getClass().getResource(resourceName), (Charset)StandardCharsets.UTF_8);
            Pattern pattern = Pattern.compile("[A-Z]+\\[\\s*\"(?<srsname>[^\"]*)\".*");
            Matcher matcher = pattern.matcher(wkt);
            if (matcher != null && matcher.matches()) {
                this.setSrsName(matcher.group("srsname"));
            } else {
                this.setSrsName(abrev);
            }
            this.setDefinition(wkt);
            this.setOrganization(authority);
            this.setOrganizationCoordsysId(authorityCode);
            this.setSrsId(authorityCode);
            this.setDescription("");
            return true;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't search projection '" + abrev + "'", (Throwable)ex);
            return false;
        }
    }

    public void setSrsName(String srs_name) {
        this.srs_name = srs_name;
    }

    public String getSrsName() {
        return this.srs_name;
    }

    public void setSrsId(int srs_id) {
        this.srs_id = srs_id;
    }

    public int getSrsId() {
        return this.srs_id;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganizationCoordsysId(int organization_coordsys_id) {
        this.organization_coordsys_id = organization_coordsys_id;
    }

    public int getOrganizationCoordsysId() {
        return this.organization_coordsys_id;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean exists(JDBCConnection conn) {
        boolean bl;
        Statement sta = null;
        ResultSet rs = null;
        try {
            String sql = String.format("Select * from gpkg_spatial_ref_sys where organization = '%s' and organization_coordsys_id = %d", this.getOrganization(), this.getOrganizationCoordsysId());
            sta = conn.createStatement(sql);
            rs = JDBCUtils.executeQuery((Statement)sta, (String)sql);
            bl = rs.next();
        }
        catch (Exception ex) {
            try {
                LOGGER.debug("Can't verify if exists the spatial_ref_sys '" + this.getOrganization() + ":" + this.getOrganizationCoordsysId() + "' in BD.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(rs);
                JDBCUtils.closeQuietly(sta);
                throw throwable;
            }
            JDBCUtils.closeQuietly((ResultSet)rs);
            JDBCUtils.closeQuietly((Statement)sta);
            return false;
        }
        JDBCUtils.closeQuietly((ResultSet)rs);
        JDBCUtils.closeQuietly((Statement)sta);
        return bl;
    }

    public void save(SQLiteHelper helper) {
        JDBCConnection conn = null;
        ResultSet tables = null;
        Statement sta = null;
        try {
            conn = helper.getConnection();
            conn.begin();
            JDBCSQLBuilderBase sqlBuilder = helper.createSQLBuilder();
            StringBuilder builder = new StringBuilder();
            if (!this.exists(conn)) {
                tables = conn.getMetaData().getTables(null, null, "gpkg_spatial_ref_sys", null);
                if (!tables.next()) {
                    GeopackageSpatialRefSys.createGpkgSpatialRefSysTable(conn);
                }
                builder.append("INSERT INTO gpkg_spatial_ref_sys (srs_name, srs_id, organization, organization_coordsys_id, definition, description) VALUES (");
                builder.append(sqlBuilder.as_string(this.getSrsName()));
                builder.append(",");
                builder.append(this.getSrsId());
                builder.append(",");
                builder.append(sqlBuilder.as_string(this.getOrganization()));
                builder.append(",'");
                builder.append(this.getOrganizationCoordsysId());
                builder.append("',");
                builder.append(sqlBuilder.as_string(this.getDefinition()));
                builder.append(",");
                builder.append(sqlBuilder.as_string(this.getDescription()));
                builder.append(")");
                String sql = builder.toString();
                sta = conn.createStatement(sql);
                JDBCUtils.execute((Statement)sta, (String)sql);
            }
        }
        catch (Exception ex2) {
            throw new GeopackageException("Can't save the spatial_ref_sys '" + this.getOrganization() + ":" + this.getOrganizationCoordsysId() + "' in BD.", ex2);
        }
        finally {
            if (conn != null) {
                try {
                    conn.commit();
                }
                catch (SQLException ex) {
                    throw new GeopackageException("Can't save the spatial_ref_sys '" + this.getOrganization() + ":" + this.getOrganizationCoordsysId() + "' in BD.", ex);
                }
            }
            JDBCUtils.closeQuietly(sta);
            JDBCUtils.closeQuietly(tables);
            JDBCConnection.closeQuietly((JDBCConnection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(JDBCConnection conn) throws SQLException {
        Statement sta = null;
        ResultSet rs = null;
        try {
            String sql = String.format("Select * from gpkg_spatial_ref_sys where organization = '%s' and organization_coordsys_id = %d", this.getOrganization(), this.getOrganizationCoordsysId());
            sta = conn.createStatement(sql);
            rs = sta.executeQuery(sql);
            if (rs.next()) {
                this.setSrsName(rs.getString("srs_name"));
                this.setSrsId(rs.getInt("srs_id"));
                this.setDefinition(rs.getString("definition"));
                this.setDescription(rs.getString("description"));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.warn("Can't load exists the spatial_ref_sys '" + this.getOrganization() + ":" + this.getOrganizationCoordsysId() + "' in BD.", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (sta != null) {
                sta.close();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createGpkgSpatialRefSysTable(JDBCConnection conn) {
        String sql = "CREATE TABLE \"gpkg_spatial_ref_sys\" (\n\t\"srs_name\"\tTEXT NOT NULL,\n\t\"srs_id\"\tINTEGER NOT NULL,\n\t\"organization\"\tTEXT NOT NULL,\n\t\"organization_coordsys_id\"\tINTEGER NOT NULL,\n\t\"definition\"\tTEXT NOT NULL,\n\t\"description\"\tTEXT,\n\tPRIMARY KEY(\"srs_id\")\n);";
        try (Statement sta = conn.createStatement(sql);){
            JDBCUtils.execute((Statement)sta, (String)sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.warn("Can't create spatial_ref_sys table'", (Throwable)ex);
            return false;
        }
    }
}

