/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.lib.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.json.Json;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyDataSetResolver;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleAction;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopologyRule
implements TopologyRule {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractTopologyRule.class);
    private TopologyPlan plan;
    private TopologyDataSetResolver datasetResolver;
    private TopologyRuleFactory factory;
    private double tolerance;
    public String dataSet1;
    private String dataSet2;
    protected List<TopologyRuleAction> actions;
    private DynObject parameters;
    private int codeExceptionCount;

    protected AbstractTopologyRule() {
    }

    protected AbstractTopologyRule(TopologyRuleFactory factory, double tolerance, String dataSet1, String dataSet2) {
        this.factory = factory;
        this.tolerance = tolerance;
        this.dataSet1 = dataSet1;
        this.dataSet2 = dataSet2;
        this.actions = new ArrayList<TopologyRuleAction>();
    }

    protected AbstractTopologyRule(TopologyRuleFactory factory, double tolerance, String dataSet1) {
        this(factory, tolerance, dataSet1, null);
    }

    @Override
    public TopologyRule clone() throws CloneNotSupportedException {
        AbstractTopologyRule other = (AbstractTopologyRule)super.clone();
        if (this.actions != null) {
            other.actions = new ArrayList<TopologyRuleAction>();
            other.actions.addAll(this.actions);
        }
        if (this.parameters != null) {
            other.parameters = DynObject.clone((DynObject)this.parameters);
        }
        return other;
    }

    @Override
    public TopologyPlan getPlan() {
        return this.plan;
    }

    public void setPlan(TopologyPlan plan) {
        this.plan = plan;
    }

    @Override
    public void setDataSetResolver(TopologyDataSetResolver resolver) {
        this.datasetResolver = resolver;
    }

    private TopologyDataSetResolver getDataSetResolver() {
        if (this.plan != null) {
            return this.plan;
        }
        return this.datasetResolver;
    }

    @Override
    public TopologyRuleFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getName() {
        return this.getFactory().getName();
    }

    @Override
    public String getId() {
        return this.getFactory().getId();
    }

    public final void addAction(TopologyRuleAction action) {
        this.actions.add(action);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TopologyRule)) {
            return false;
        }
        AbstractTopologyRule other = (AbstractTopologyRule)obj;
        if (!StringUtils.equals((CharSequence)this.getName(), (CharSequence)other.getName())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.dataSet1, (CharSequence)other.dataSet1)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.dataSet2, (CharSequence)other.dataSet2);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.factory);
        hash = 71 * hash + (int)(Double.doubleToLongBits(this.tolerance) ^ Double.doubleToLongBits(this.tolerance) >>> 32);
        hash = 71 * hash + Objects.hashCode(this.dataSet1);
        hash = 71 * hash + Objects.hashCode(this.dataSet2);
        return hash;
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (Throwable th) {
            return super.toString();
        }
    }

    @Override
    public TopologyDataSet getDataSet1() {
        return this.getDataSetResolver().getDataSet(this.dataSet1);
    }

    @Override
    public TopologyDataSet getDataSet2() {
        return this.getDataSetResolver().getDataSet(this.dataSet2);
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public List<TopologyRuleAction> getActions() {
        if (this.actions == null) {
            return null;
        }
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public TopologyRuleAction getAction(String id) {
        for (TopologyRuleAction action : this.actions) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)action.getId())) continue;
            return action;
        }
        return null;
    }

    @Override
    public long getSteps() {
        return this.getDataSet1().getSize();
    }

    @Override
    public void execute(SimpleTaskStatus taskStatus, TopologyReport report) {
        try {
            this.codeExceptionCount = 0;
            this.getDataSet1().accept(o1 -> {
                if (taskStatus.isCancellationRequested()) {
                    throw new VisitCanceledException();
                }
                taskStatus.incrementCurrentValue();
                try {
                    this.check(taskStatus, report, (Feature)o1);
                }
                catch (Exception ex) {
                    this.addCodeException(report, (Feature)o1, ex);
                }
            });
        }
        catch (VisitCanceledException ex) {
            report.addLine(this, null, null, null, null, null, null, true, "");
        }
    }

    protected void check(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature) throws Exception {
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public org.gvsig.json.JsonObjectBuilder toJsonBuilder() {
        org.gvsig.json.JsonObjectBuilder me = Json.createObjectBuilder();
        me.add_class((Object)this);
        me.add("ruleid", this.getId());
        me.add("tolerance", this.tolerance);
        me.add("dataSet1", this.dataSet1);
        me.add("dataSet2", this.dataSet2);
        DynObject params = this.getParameters();
        if (params != null) {
            org.gvsig.json.JsonObjectBuilder jsonParams = Json.createObjectBuilder();
            DynClass parametersDefinition = params.getDynClass();
            for (DynField dynField : parametersDefinition.getDynFields()) {
                jsonParams.add(dynField.getName(), params.getDynValue(dynField.getName()));
            }
            me.add("params", (JsonObjectBuilder)jsonParams);
        }
        return me;
    }

    public void fromJson(JsonObject json) {
        TopologyManager manager = TopologyLocator.getTopologyManager();
        String ruleid = json.getString("ruleid", null);
        this.factory = manager.getRulefactory(ruleid);
        if (json.containsKey((Object)"tolerance")) {
            this.tolerance = json.getJsonNumber("tolerance").doubleValue();
        }
        this.dataSet1 = json.getString("dataSet1", null);
        this.dataSet2 = json.getString("dataSet2", null);
        if (json.containsKey((Object)"params")) {
            JsonObject jsonParams = json.getJsonObject("params");
            DynObject params = this.getFactory().createRuleParameters();
            DynClass parametersDefinition = params.getDynClass();
            for (DynField dynField : parametersDefinition.getDynFields()) {
                String paramName = dynField.getName();
                if (!jsonParams.containsKey((Object)paramName)) continue;
                params.setDynValue(paramName, Json.toObject((JsonObject)jsonParams, (String)paramName));
            }
            this.setParameters(params);
        }
    }

    @Override
    public void setParameters(DynObject parameters) {
        this.parameters = parameters;
    }

    @Override
    public DynObject getParameters() {
        return this.parameters;
    }

    protected void substract(FeatureReference featRef, Geometry geomToSubstract, TopologyDataSet dataSet) throws DataException, GeometryOperationException, GeometryOperationNotSupportedException {
        Feature feat = featRef.getFeature();
        EditableFeature editFeat = feat.getEditable();
        Geometry geom = editFeat.getDefaultGeometry();
        Geometry diff = geom.difference(geomToSubstract);
        editFeat.setDefaultGeometry(diff);
        dataSet.update(editFeat);
    }

    protected void createNewFeature(FeatureReference featRef, TopologyDataSet dataSet, Geometry newGeom) throws DataException {
        Feature featureToCopyFrom = featRef.getFeature();
        EditableFeature targetFeature = dataSet.createNewFeature();
        targetFeature.copyFrom(featureToCopyFrom);
        targetFeature.setDefaultGeometry(newGeom);
        dataSet.insert(targetFeature);
    }

    protected void addCodeException(TopologyReport report, Feature feature1, Exception ex) {
        if (this.codeExceptionCount++ > 10) {
            return;
        }
        report.addCodeException(this, this.getDataSet1(), feature1, ex);
    }
}

