/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap;

import java.awt.Image;
import javax.swing.ImageIcon;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconThemeHelper {
    private static Logger logger = LoggerFactory.getLogger(IconThemeHelper.class);

    public static void registerIcon(String group, String name, Object obj) {
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        String resourceName = group == null || group.trim().length() == 0 ? "images/" + name + ".png" : "images/" + group + "/" + name + ".png";
        ClassLoader loader = obj instanceof Class ? ((Class)obj).getClassLoader() : obj.getClass().getClassLoader();
        try {
            iconTheme.registerDefault("mapcontrol", group, name, null, loader.getResource(resourceName));
        }
        catch (Throwable e) {
            logger.info(e.getMessage());
        }
    }

    public static ImageIcon getImageIcon(String iconName) {
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        return iconTheme.get(iconName);
    }

    public static Image getImage(String iconName) {
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        return iconTheme.get(iconName).getImage();
    }
}

