/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.expresionPanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontrol.dal.expresionPanel.ExpresionPanelLayout;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpresionPanel
extends ExpresionPanelLayout {
    private static final Logger logger = LoggerFactory.getLogger(ExpresionPanel.class);
    private FeatureStore store;
    private Map values;
    private boolean okCancelVisible = true;
    private boolean isCanceled = false;

    public ExpresionPanel(FeatureStore store) {
        this.initComponents();
    }

    public void setFeatureStore(FeatureStore store) {
        this.store = store;
        try {
            this.lstFields.setModel(new FeatureTypeListModel(this.store.getDefaultFeatureType()));
        }
        catch (DataException ex) {
            logger.warn("Can't create model for field list.", (Throwable)ex);
        }
    }

    public void setOkCancelVisible(boolean acceptVisible) {
        this.okCancelVisible = acceptVisible;
    }

    public boolean getOkCancelVisible() {
        return this.okCancelVisible;
    }

    private void initComponents() {
        this.butAccept.setVisible(this.okCancelVisible);
        this.lstFields.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExpresionPanel.this.doSelectField();
            }
        });
        this.lstValues.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExpresionPanel.this.doSelectValue();
            }
        });
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpresionPanel.this.doInsert(e.getActionCommand() + " ");
            }
        };
        this.butAnd.addActionListener(action);
        this.butOr.addActionListener(action);
        this.butNot.addActionListener(action);
        this.butEq.addActionListener(action);
        this.butNe.addActionListener(action);
        this.butGt.addActionListener(action);
        this.butLt.addActionListener(action);
        this.butGe.addActionListener(action);
        this.butLe.addActionListener(action);
        this.butClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpresionPanel.this.doClear();
            }
        });
        this.butAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpresionPanel.this.doAcept();
            }
        });
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpresionPanel.this.doCancel();
            }
        });
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public String getExpresion() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.txtExpresion.getText(), null);
    }

    public void showAsDialog(String title) {
        WindowManager winmgr = ToolsSwingLocator.getWindowManager();
        winmgr.showWindow((JComponent)this, title, WindowManager.MODE.DIALOG);
    }

    private void doAcept() {
        this.isCanceled = false;
        this.setVisible(false);
    }

    private void doCancel() {
        this.isCanceled = true;
        this.setVisible(false);
    }

    private void doSelectField() {
        FeatureAttributeDescriptor x = (FeatureAttributeDescriptor)this.lstFields.getSelectedValue();
        if (x == null) {
            return;
        }
        this.doInsert(x.getName());
        this.doInsert(" ");
        this.fillValuesList(x.getName());
    }

    private void doClear() {
        this.txtExpresion.setText("");
    }

    private void doSelectValue() {
    }

    private void doInsert(String s) {
        this.txtExpresion.insert(s, this.txtExpresion.getCaretPosition());
    }

    private void fillValuesList(String name) {
    }

    private static class FeatureTypeListModel
    implements ListModel {
        private final FeatureType featureType;

        public FeatureTypeListModel(FeatureType featureType) {
            this.featureType = featureType;
        }

        @Override
        public int getSize() {
            return this.featureType.size();
        }

        public Object getElementAt(int index) {
            return this.featureType.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

