/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureAttributeCellRenderer;

public class BooleanCellRenderer
extends FeatureAttributeCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private final JCheckBox chkBox = new JCheckBox();

    public BooleanCellRenderer() {
        this.chkBox.setHorizontalAlignment(0);
        this.chkBox.setBorderPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.chkBox.setBackground(this.getBackgroundColor(table, isSelected, row, column));
            if (isSelected) {
                this.chkBox.setForeground(table.getSelectionForeground());
            } else {
                this.chkBox.setForeground(table.getForeground());
            }
            this.chkBox.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.chkBox.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.chkBox.setBorder(noFocusBorder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }
}

