/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.GeometryToWKTException;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.TextAreaCellEditor;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.WKTToGeometryException;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryWKTCellEditor
extends TextAreaCellEditor {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(GeometryWKTCellEditor.class);
    public static final int DEFAULT_MAX_WKT_LENGTH = 10000;
    private static final long serialVersionUID = -2296004227902843851L;
    private int maxRowHeight;

    public GeometryWKTCellEditor() {
        this(10000, 160);
    }

    public GeometryWKTCellEditor(int maxWKTLength, int maxRowHeight) {
        this.delegate = new GeometryToWKTDelegate(this.delegate, maxWKTLength);
        this.maxRowHeight = maxRowHeight;
    }

    @Override
    public Object getCellEditorValue() {
        String wkt = (String)super.getCellEditorValue();
        try {
            if (wkt == null || StringUtils.isEmpty((CharSequence)wkt.trim())) {
                return null;
            }
            return geomManager.createFrom(wkt);
        }
        catch (Exception ex) {
            throw new WKTToGeometryException(wkt, ex);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate.setValue(value);
        if (((GeometryToWKTDelegate)this.delegate).isWtkTextTooLong()) {
            JOptionPane.showMessageDialog(table.getParent(), Messages.getText((String)"Geometria_no_editable_WKT"), Messages.getText((String)"Error_editar_geometria"), 0);
            return null;
        }
        int height_wanted = (int)this.getTextArea().getPreferredSize().getHeight();
        int n = height_wanted = height_wanted > this.maxRowHeight ? this.maxRowHeight : height_wanted;
        if (height_wanted > table.getRowHeight(row)) {
            int previousRowHeight = table.getRowHeight();
            table.setRowHeight(row, height_wanted);
            table.firePropertyChange("rowheight", previousRowHeight, height_wanted);
        }
        return this.editorComponent;
    }

    private class GeometryToWKTDelegate
    extends DefaultCellEditor.EditorDelegate {
        private DefaultCellEditor.EditorDelegate delegate;
        private boolean wtkTextTooLong;
        private int maxWKTLength;

        public GeometryToWKTDelegate(DefaultCellEditor.EditorDelegate delegate, int maxWKTLength) {
            super(GeometryWKTCellEditor.this);
            this.wtkTextTooLong = false;
            this.delegate = delegate;
            this.maxWKTLength = maxWKTLength;
        }

        public boolean isWtkTextTooLong() {
            return this.wtkTextTooLong;
        }

        @Override
        public void setValue(Object value) {
            this.wtkTextTooLong = false;
            String strValue = "";
            if (value != null) {
                try {
                    Geometry geometry = (Geometry)value;
                    strValue = geometry.convertToWKT();
                    if (strValue.length() > this.maxWKTLength) {
                        this.wtkTextTooLong = true;
                        this.delegate.setValue(null);
                    } else {
                        this.delegate.setValue(strValue);
                    }
                }
                catch (Exception ex) {
                    throw new GeometryToWKTException(ex);
                }
            }
        }

        @Override
        public Object getCellEditorValue() {
            if (this.wtkTextTooLong) {
                return null;
            }
            return this.delegate.getCellEditorValue();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }

        @Override
        public void cancelCellEditing() {
            this.delegate.cancelCellEditing();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.delegate.isCellEditable(anEvent);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.delegate.itemStateChanged(e);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.delegate.shouldSelectCell(anEvent);
        }

        @Override
        public boolean startCellEditing(EventObject anEvent) {
            return this.delegate.startCellEditing(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.delegate.stopCellEditing();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

