/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TextAreaCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = 3269365116036190589L;
    private final DefaultTableCellRenderer adaptee = new DefaultTableCellRenderer();
    private final Map<JTable, Map<Integer, Map<Integer, Integer>>> cellSizes = new HashMap<JTable, Map<Integer, Map<Integer, Integer>>>();
    private int maxTxtLength = Integer.MAX_VALUE;
    private int maxRowHeight = Integer.MAX_VALUE;

    public TextAreaCellRenderer() {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public TextAreaCellRenderer(int maxTxtLength, int maxRowHeight) {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.maxTxtLength = maxTxtLength;
        this.maxRowHeight = maxRowHeight;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        this.adaptee.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
        this.setForeground(this.adaptee.getForeground());
        this.setBackground(this.adaptee.getBackground());
        this.setBorder(this.adaptee.getBorder());
        this.setFont(this.adaptee.getFont());
        String cellTxt = this.getCellText(obj, row, column);
        if (cellTxt.length() > this.maxTxtLength) {
            cellTxt = cellTxt.substring(0, this.maxTxtLength - 4).concat(" ...");
        }
        this.setText(cellTxt);
        TableColumnModel columnModel = table.getColumnModel();
        this.setSize(columnModel.getColumn(column).getWidth(), 100000);
        int height_wanted = (int)this.getPreferredSize().getHeight();
        height_wanted = height_wanted > this.maxRowHeight ? this.maxRowHeight : height_wanted;
        this.addSize(table, row, column, height_wanted);
        height_wanted = this.findTotalMaximumRowSize(table, row);
        if (height_wanted != table.getRowHeight(row)) {
            int previousRowHeight = table.getRowHeight();
            table.setRowHeight(row, height_wanted);
            table.firePropertyChange("rowheight", previousRowHeight, height_wanted);
        }
        return this;
    }

    protected String getCellText(Object value, int row, int column) {
        return this.adaptee.getText();
    }

    private void addSize(JTable table, int row, int column, int height) {
        Map<Integer, Integer> rowheights;
        Map<Integer, Map<Integer, Integer>> rows = this.cellSizes.get(table);
        if (rows == null) {
            rows = new HashMap<Integer, Map<Integer, Integer>>();
            this.cellSizes.put(table, rows);
        }
        if ((rowheights = rows.get(row)) == null) {
            rowheights = new HashMap<Integer, Integer>();
            rows.put(row, rowheights);
        }
        rowheights.put(column, height);
    }

    private int findTotalMaximumRowSize(JTable table, int row) {
        int maximum_height = 0;
        for (int column = 0; column < table.getColumnCount(); ++column) {
            TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
            if (!(cellRenderer instanceof TextAreaCellRenderer)) continue;
            TextAreaCellRenderer tar = (TextAreaCellRenderer)cellRenderer;
            maximum_height = Math.max(maximum_height, tar.findMaximumRowSize(table, row));
        }
        return maximum_height;
    }

    private int findMaximumRowSize(JTable table, int row) {
        Map<Integer, Map<Integer, Integer>> rows = this.cellSizes.get(table);
        if (rows == null) {
            return 0;
        }
        Map<Integer, Integer> rowheights = rows.get(row);
        if (rowheights == null) {
            return 0;
        }
        int maximum_height = 0;
        for (Map.Entry<Integer, Integer> entry : rowheights.entrySet()) {
            int cellHeight = entry.getValue();
            maximum_height = Math.max(maximum_height, cellHeight);
        }
        return maximum_height;
    }
}

