/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.swing.dynobject;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynObjectEditor
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 23898787077741411L;
    private static final Logger LOG = LoggerFactory.getLogger(DynObjectEditor.class);
    private String title;
    private JButton botAcept;
    private JButton botCancel;
    private JButton botRestoreDefaults;
    private JPanel panButtons;
    private JDynForm form = null;
    private DynObject data = null;
    private boolean isCanceled = false;
    private Runnable onclose = null;

    public DynObjectEditor(DynObject data, boolean showDefaultsButton) {
        this.data = data;
        this.form = DynFormLocator.getDynFormManager().createJDynForm(this.data);
        this.form.setLayoutMode(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.form.asJComponent(), "Center");
        this.add((Component)this.getButtonsPanel(showDefaultsButton), "South");
        this.setPreferredSize(new Dimension(500, 250));
        String s = this.data.getDynClass().getDescription();
        if (s == null || s.length() == 0) {
            s = this.data.getDynClass().getName();
        }
        this.setTitle(s);
    }

    public DynObjectEditor(DynObject data) throws ServiceException {
        this(data, false);
    }

    private JPanel getButtonsPanel(boolean add_defaults_button) {
        if (this.panButtons == null) {
            this.panButtons = new JPanel();
            this.panButtons.setLayout(new GridBagLayout());
            GridBagConstraints constr = new GridBagConstraints();
            constr.anchor = 26;
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.weighty = 0.0;
            this.panButtons.add((Component)new JLabel(), constr);
            constr = this.getDefaultParametersConstraints();
            constr.fill = 0;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            this.panButtons.add((Component)this.getAcceptButton(), constr);
            this.panButtons.add((Component)this.getCancelButton(), constr);
            if (add_defaults_button) {
                this.panButtons.add((Component)this.getRestoreDefaults(), constr);
            }
        }
        return this.panButtons;
    }

    private GridBagConstraints getDefaultParametersConstraints() {
        GridBagConstraints constr = new GridBagConstraints();
        constr.insets = new Insets(2, 2, 2, 2);
        constr.ipadx = 2;
        constr.ipady = 2;
        constr.anchor = 19;
        return constr;
    }

    private JButton getRestoreDefaults() {
        if (this.botRestoreDefaults == null) {
            this.botRestoreDefaults = ToolsSwingLocator.getUsabilitySwingManager().createJButton(Messages.getText((String)"restoreDefaults"));
            this.botRestoreDefaults.addActionListener(this);
        }
        return this.botRestoreDefaults;
    }

    private JButton getCancelButton() {
        if (this.botCancel == null) {
            this.botCancel = ToolsSwingLocator.getUsabilitySwingManager().createJButton(Messages.getText((String)"cancel"));
            this.botCancel.addActionListener(this);
        }
        return this.botCancel;
    }

    private JButton getAcceptButton() {
        if (this.botAcept == null) {
            this.botAcept = ToolsSwingLocator.getUsabilitySwingManager().createJButton(Messages.getText((String)"accept"));
            this.botAcept.addActionListener(this);
        }
        return this.botAcept;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component source = (Component)e.getSource();
        if (source == this.botAcept) {
            this.form.getValues(this.data);
            this.isCanceled = false;
            this.closeWindow();
        } else if (source == this.botCancel) {
            this.isCanceled = true;
            this.closeWindow();
        } else if (source == this.botRestoreDefaults) {
            this.form.setValues(this.data);
        }
    }

    public void setOnClose(Runnable onclose) {
        this.onclose = onclose;
    }

    protected void closeWindow() {
        LOG.debug("Closing window, values edited: ", (Object)this.data);
        this.setVisible(false);
        if (this.onclose != null) {
            this.onclose.run();
        }
    }

    public void editObject(boolean modal) {
        WindowManager wmanager = ToolsSwingLocator.getWindowManager();
        WindowManager.MODE mode = WindowManager.MODE.WINDOW;
        if (modal) {
            mode = WindowManager.MODE.DIALOG;
        }
        wmanager.showWindow((JComponent)this, this.title, mode);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DynObject getParameters() {
        return this.getData();
    }

    public DynObject getData() {
        this.form.getValues(this.data);
        return this.data;
    }

    public DynObject getData(DynObject data) {
        this.form.getValues(data);
        return data;
    }

    public void putData(DynObject data) {
        this.form.setValues(data);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

