/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.swing.pickercontroller.impl;

import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.swing.pickercontroller.impl.ScalePickerControllerImpl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.tools.IllegalValueException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.documentfilters.DoubleDocumentFilter;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;

public class EnvelopePickerControllerImpl
extends AbstractPickerController<Envelope> {
    private final Supplier<MapControl> mapControl;
    private final JTextField txtUpperLeftX;
    private final JTextField txtUpperLeftY;
    private final JTextField txtLowerRightX;
    private final JTextField txtLowerRightY;
    private final JTextComponent txtEnvelope;
    private final JButton btnMapControlEnvelope;
    private final JToggleButton btnCapture;
    private ImageIcon captureCursor;
    private RectangleBehavior captureTool;
    private String previosTool;

    public static void selfRegister() {
        ImageIcon icon;
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getActive();
        URL url = ScalePickerControllerImpl.class.getClassLoader().getResource("images/picker-envelope-cursor-capture.png");
        if (url != null) {
            icon = new ImageIcon(url);
            theme.registerDefault("mapcontrol", "picker", "picker-envelope", "picker-envelope-cursor-capture", icon, url);
        }
        if ((url = ScalePickerControllerImpl.class.getClassLoader().getResource("images/picker-envelope-capture.png")) != null) {
            icon = new ImageIcon(url);
            theme.registerDefault("mapcontrol", "picker", "picker-envelope", "picker-envelope-capture", icon, url);
        }
        if ((url = ScalePickerControllerImpl.class.getClassLoader().getResource("images/picker-envelope-from-mapcontrol.png")) != null) {
            icon = new ImageIcon(url);
            theme.registerDefault("mapcontrol", "picker", "picker-envelope", "picker-envelope-from-mapcontrol", icon, url);
        }
        ToolsSwingUtils.registerSubgroupIconScreenshot(EnvelopePickerControllerImpl.class, (String)"picker", (String)"picker-envelope", (String)"/images/screenshots/picker-envelope1.png");
    }

    public EnvelopePickerControllerImpl(Supplier<MapControl> mapControl, JTextField txtUpperLeftX, JTextField txtUpperLeftY, JTextField txtLowerRightX, JTextField txtLowerRightY, JButton btnMapControlEnvelope, JToggleButton btnCapture) {
        this.mapControl = mapControl;
        this.txtEnvelope = null;
        this.txtUpperLeftX = txtUpperLeftX;
        this.txtUpperLeftY = txtUpperLeftY;
        this.txtLowerRightX = txtLowerRightX;
        this.txtLowerRightY = txtLowerRightY;
        this.btnMapControlEnvelope = btnMapControlEnvelope;
        this.btnCapture = btnCapture;
        this.initComponents();
    }

    public EnvelopePickerControllerImpl(Supplier<MapControl> mapControl, JTextComponent txtEnvelope, JButton btnMapControlEnvelope, JToggleButton btnCapture) {
        this.mapControl = mapControl;
        this.txtEnvelope = txtEnvelope;
        this.txtUpperLeftX = new JTextField();
        this.txtUpperLeftY = new JTextField();
        this.txtLowerRightX = new JTextField();
        this.txtLowerRightY = new JTextField();
        this.btnMapControlEnvelope = btnMapControlEnvelope;
        this.btnCapture = btnCapture;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        MapControl theMapControl = this.getMapControl();
        this.captureCursor = new ImageIcon(this.getIcon("picker-envelope-cursor-capture").getImage());
        if (this.btnCapture != null) {
            this.btnCapture.setIcon(this.getIcon("picker-envelope-capture"));
            this.btnCapture.setToolTipText(i18n.getTranslation("_Capture_an_area_in_the_view"));
            if (this.btnCapture.getText().equals("...")) {
                this.btnCapture.setText("");
            }
            this.btnCapture.addActionListener(e -> this.doCaptureEnvelope(this.btnCapture.isSelected()));
            this.btnCapture.setEnabled(this.mapControl != null);
        }
        if (this.btnMapControlEnvelope != null) {
            this.btnMapControlEnvelope.setIcon(this.getIcon("picker-envelope-from-mapcontrol"));
            this.btnMapControlEnvelope.setToolTipText(i18n.getTranslation("_Capture_the_view_area"));
            if (this.btnMapControlEnvelope.getText().equals("...")) {
                this.btnMapControlEnvelope.setText("");
            }
            this.btnMapControlEnvelope.addActionListener(e -> this.doSetEnvelopeFromMapControlEnvelope());
            this.btnMapControlEnvelope.setEnabled(this.mapControl != null);
        }
        if (theMapControl != null) {
            this.captureTool = new RectangleBehavior(new CaptureEnvelopeListener());
            theMapControl.addBehavior("picker-envelope-capture", this.captureTool);
            this.previosTool = this.mapControl.get().getCurrentTool();
        }
        if (this.txtEnvelope == null) {
            toolsSwingManager.addClearButton((JTextComponent)this.txtUpperLeftX);
            toolsSwingManager.addClearButton((JTextComponent)this.txtUpperLeftY);
            toolsSwingManager.addClearButton((JTextComponent)this.txtLowerRightX);
            toolsSwingManager.addClearButton((JTextComponent)this.txtLowerRightY);
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtUpperLeftX);
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtUpperLeftY);
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtLowerRightX);
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtLowerRightY);
            this.txtUpperLeftX.setHorizontalAlignment(4);
            this.txtUpperLeftY.setHorizontalAlignment(4);
            this.txtLowerRightX.setHorizontalAlignment(4);
            this.txtLowerRightY.setHorizontalAlignment(4);
            this.txtUpperLeftX.setText("#########,00000");
            Dimension dim = this.txtUpperLeftX.getPreferredSize();
            this.txtUpperLeftX.setText("");
            this.txtUpperLeftX.setPreferredSize(dim);
            this.txtUpperLeftY.setPreferredSize(dim);
            this.txtLowerRightX.setPreferredSize(dim);
            this.txtLowerRightY.setPreferredSize(dim);
            DoubleDocumentFilter.install((JTextField)this.txtUpperLeftX);
            DoubleDocumentFilter.install((JTextField)this.txtUpperLeftY);
            DoubleDocumentFilter.install((JTextField)this.txtLowerRightX);
            DoubleDocumentFilter.install((JTextField)this.txtLowerRightY);
        } else {
            toolsSwingManager.addClearButton(this.txtEnvelope);
            toolsSwingManager.setDefaultPopupMenu(this.txtEnvelope);
        }
    }

    protected void doSetEnvelopeFromMapControlEnvelope() {
        MapControl theMapControl = this.getMapControl();
        if (!this.isEditable() || theMapControl == null) {
            return;
        }
        try {
            Envelope env = theMapControl.getViewPort().getEnvelope();
            if (env == null) {
                return;
            }
            Envelope theEnvelope = (Envelope)env.clone();
            this.set(theEnvelope);
        }
        catch (Exception ex) {
            LOG.warn("Can't get envelope from mapcontrol.", (Throwable)ex);
        }
    }

    protected void doCaptureEnvelope(boolean enabled) {
        MapControl theMapControl = this.getMapControl();
        if (!this.isEditable() || theMapControl == null) {
            return;
        }
        Envelope env = theMapControl.getViewPort().getEnvelope();
        if (env == null) {
            return;
        }
        if (enabled) {
            this.previosTool = theMapControl.getCurrentTool();
            theMapControl.setTool("picker-envelope-capture");
        } else {
            theMapControl.setTool(this.previosTool);
        }
    }

    protected String getEnvelopeAsString(Envelope value) {
        String s = String.format("%+f, %+f, %+f, %+f", value.getMinimum(0), value.getMaximum(1), value.getMaximum(0), value.getMinimum(1));
        return s;
    }

    public boolean isValid() {
        if (this.txtEnvelope == null) {
            if (DoubleDocumentFilter.isEmpty((JTextField)this.txtUpperLeftX) && DoubleDocumentFilter.isEmpty((JTextField)this.txtUpperLeftY) && DoubleDocumentFilter.isEmpty((JTextField)this.txtLowerRightX) && DoubleDocumentFilter.isEmpty((JTextField)this.txtLowerRightY)) {
                return true;
            }
            if (DoubleDocumentFilter.isEmpty((JTextField)this.txtUpperLeftX) || DoubleDocumentFilter.isEmpty((JTextField)this.txtUpperLeftY) || DoubleDocumentFilter.isEmpty((JTextField)this.txtLowerRightX) || DoubleDocumentFilter.isEmpty((JTextField)this.txtLowerRightY)) {
                return false;
            }
            if (!DoubleDocumentFilter.isValid((JTextField)this.txtUpperLeftX)) {
                return false;
            }
            if (!DoubleDocumentFilter.isValid((JTextField)this.txtUpperLeftY)) {
                return false;
            }
            if (!DoubleDocumentFilter.isValid((JTextField)this.txtLowerRightX)) {
                return false;
            }
            return DoubleDocumentFilter.isValid((JTextField)this.txtLowerRightY);
        }
        if (StringUtils.isBlank((CharSequence)this.txtEnvelope.getText())) {
            return true;
        }
        try {
            GeometryUtils.createFrom((String)this.txtEnvelope.getText());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (this.txtEnvelope == null) {
            return DoubleDocumentFilter.isEmpty((JTextField)this.txtUpperLeftX) && DoubleDocumentFilter.isEmpty((JTextField)this.txtUpperLeftY) && DoubleDocumentFilter.isEmpty((JTextField)this.txtLowerRightX) && DoubleDocumentFilter.isEmpty((JTextField)this.txtLowerRightY);
        }
        return StringUtils.isBlank((CharSequence)this.txtEnvelope.getText());
    }

    public Envelope get() {
        if (this.isEmpty()) {
            return null;
        }
        if (!this.isValid()) {
            throw new IllegalValueException();
        }
        Envelope envelope = null;
        if (this.txtEnvelope == null) {
            try {
                double upperLeftX = DoubleDocumentFilter.getValue((JTextField)this.txtUpperLeftX);
                double upperLeftY = DoubleDocumentFilter.getValue((JTextField)this.txtUpperLeftY);
                double lowerRightX = DoubleDocumentFilter.getValue((JTextField)this.txtLowerRightX);
                double lowerRightY = DoubleDocumentFilter.getValue((JTextField)this.txtLowerRightY);
                GeometryManager geomManager = GeometryLocator.getGeometryManager();
                envelope = geomManager.createEnvelope(0);
                Point upperLeft = geomManager.createPoint(upperLeftX, upperLeftY, 0);
                Point lowerRight = geomManager.createPoint(lowerRightX, lowerRightY, 0);
                envelope.setUpperCorner(upperLeft);
                envelope.setLowerCorner(lowerRight);
            }
            catch (Exception ex) {
                return null;
            }
        }
        try {
            Geometry geom = GeometryUtils.createFrom((String)this.txtEnvelope.getText());
            envelope = geom.getEnvelope();
        }
        catch (Exception ex) {
            return null;
        }
        MapControl theMapControl = this.getMapControl();
        if (theMapControl != null) {
            envelope.setProjection(theMapControl.getProjection());
        }
        return envelope;
    }

    public void set(Envelope envelope) {
        if (envelope == null) {
            this.clear();
            return;
        }
        if (envelope.isCollapsed()) {
            this.clear();
            return;
        }
        if (this.txtEnvelope == null) {
            this.txtUpperLeftX.setText(String.format("%+f", envelope.getMinimum(0)));
            this.txtUpperLeftY.setText(String.format("%+f", envelope.getMaximum(1)));
            this.txtLowerRightX.setText(String.format("%+f", envelope.getMaximum(0)));
            this.txtLowerRightY.setText(String.format("%+f", envelope.getMinimum(1)));
        } else {
            this.txtEnvelope.setText(envelope.getBox2D().convertToWKTQuietly());
        }
        this.fireChangeEvent();
    }

    public void coerceAndSet(Object value) {
        if (value == null) {
            this.clear();
            return;
        }
        DataType dataType = ToolsLocator.getDataTypesManager().get(67);
        try {
            this.set((Envelope)dataType.coerce(value));
        }
        catch (CoercionException ex) {
            LOG.warn("Can't set value.", (Throwable)ex);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.txtEnvelope == null) {
            this.txtUpperLeftX.setEnabled(enabled);
            this.txtUpperLeftY.setEnabled(enabled);
            this.txtLowerRightX.setEnabled(enabled);
            this.txtLowerRightY.setEnabled(enabled);
        } else {
            this.txtEnvelope.setEnabled(enabled);
        }
        if (this.mapControl == null) {
            this.btnCapture.setEnabled(false);
            this.btnMapControlEnvelope.setEnabled(false);
        } else {
            this.btnCapture.setEnabled(enabled);
            this.btnMapControlEnvelope.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        if (this.txtEnvelope != null) {
            return this.txtEnvelope.isEnabled();
        }
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.txtEnvelope == null) {
            this.txtUpperLeftX.setEditable(editable);
            this.txtUpperLeftY.setEditable(editable);
            this.txtLowerRightX.setEditable(editable);
            this.txtLowerRightY.setEditable(editable);
        } else {
            this.txtEnvelope.setEditable(editable);
        }
    }

    public void clear() {
        if (this.txtEnvelope == null) {
            this.txtUpperLeftX.setText("");
            this.txtUpperLeftY.setText("");
            this.txtLowerRightX.setText("");
            this.txtLowerRightY.setText("");
        } else {
            this.txtEnvelope.setText("");
        }
        this.fireChangeEvent();
    }

    private MapControl getMapControl() {
        if (this.mapControl == null) {
            return null;
        }
        return this.mapControl.get();
    }

    private class CaptureEnvelopeListener
    implements RectangleListener {
        private CaptureEnvelopeListener() {
        }

        @Override
        public void rectangle(EnvelopeEvent event) throws BehaviorException {
            EnvelopePickerControllerImpl.this.set(event.getWorldCoordRect());
        }

        @Override
        public Image getImageCursor() {
            return EnvelopePickerControllerImpl.this.captureCursor.getImage();
        }

        @Override
        public boolean cancelDrawing() {
            return false;
        }
    }
}

