/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MoveEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;

public class DraggerBehavior
extends Behavior {
    private Point2D m_FirstPoint;
    private PanListener listener;

    public DraggerBehavior(PanListener pli) {
        this.listener = pli;
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.m_FirstPoint = e.getPoint();
        }
        if (this.listener.cancelDrawing()) {
            this.getMapControl().cancelDrawing();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        this.m_FirstPoint = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        MoveEvent event = new MoveEvent(this.m_FirstPoint, e.getPoint(), e);
        this.listener.move(event);
        this.getMapControl().repaint();
    }

    public void setListener(ToolListener listener) {
        this.listener = (PanListener)listener;
    }

    @Override
    public ToolListener getListener() {
        return this.listener;
    }
}

