/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RectangleBehavior
extends Behavior {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(RectangleBehavior.class);
    private Point2D m_FirstPoint;
    private Point2D m_LastPoint;
    private RectangleListener listener;

    public RectangleBehavior(RectangleListener zili) {
        this.listener = zili;
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
        mapControlDrawer.setColor(Color.black);
        Rectangle r = new Rectangle();
        if (this.m_FirstPoint != null && this.m_LastPoint != null) {
            r.setFrameFromDiagonal(this.m_FirstPoint, this.m_LastPoint);
            mapControlDrawer.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isMyButton(e)) {
            return;
        }
        if (e.getButton() == 1) {
            this.m_FirstPoint = e.getPoint();
            this.getMapControl().repaint();
        }
        if (this.listener.cancelDrawing()) {
            this.getMapControl().cancelDrawing();
            this.getMapControl().repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (!this.isMyButton(e)) {
            return;
        }
        if (this.m_FirstPoint == null) {
            return;
        }
        Point pScreen = e.getPoint();
        ViewPort vp = this.getMapControl().getMapContext().getViewPort();
        Point2D p1 = vp.toMapPoint(this.m_FirstPoint);
        Point2D p2 = vp.toMapPoint((Point2D)pScreen);
        if (e.getButton() == 1) {
            double x = 0.0;
            double y = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            if (p1.getX() < p2.getX()) {
                x = p1.getX();
                x1 = p2.getX();
            } else {
                x = p2.getX();
                x1 = p1.getX();
            }
            if (p1.getY() < p2.getY()) {
                y = p1.getY();
                y1 = p2.getY();
            } else {
                y = p2.getY();
                y1 = p1.getY();
            }
            try {
                Envelope r = geomManager.createEnvelope(x, y, x1, y1, 0);
                r.setProjection(vp.getProjection());
                Rectangle rectPixel = new Rectangle();
                rectPixel.setFrameFromDiagonal(this.m_FirstPoint, pScreen);
                EnvelopeEvent event = new EnvelopeEvent(r, e, rectPixel);
                this.listener.rectangle(event);
            }
            catch (CreateEnvelopeException e1) {
                logger.error("Error creating the envelope", (Object)e);
            }
        }
        this.m_FirstPoint = null;
        this.m_LastPoint = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isMyButton(e)) {
            return;
        }
        this.m_LastPoint = e.getPoint();
        this.getMapControl().repaint();
    }

    public void setListener(ToolListener listener) {
        this.listener = (RectangleListener)listener;
    }

    @Override
    public ToolListener getListener() {
        return this.listener;
    }
}

