/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;

public class RectangleSelectionListener
implements RectangleListener {
    private MapControl mapCtrl;

    public RectangleSelectionListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rectangle(EnvelopeEvent event) throws BehaviorException {
        try {
            Envelope rect = event.getWorldCoordRect();
            FLayer[] actives = this.mapCtrl.getMapContext().getLayers().getActives();
            for (int i = 0; i < actives.length; ++i) {
                FeatureSet newSelection;
                block8: {
                    if (!(actives[i] instanceof FLyrVect)) continue;
                    FLyrVect lyrVect = (FLyrVect)actives[i];
                    newSelection = null;
                    try {
                        newSelection = event.getEvent().isShiftDown() ? lyrVect.queryByContainedInEnvelope(rect, lyrVect.getFeatureStore().getDefaultFeatureType()) : lyrVect.queryByEnvelope(rect, lyrVect.getFeatureStore().getDefaultFeatureType());
                        if (event.getEvent().isControlDown()) {
                            FeatureSelection currentSelection = (FeatureSelection)lyrVect.getFeatureStore().getSelection();
                            DisposableIterator it = newSelection.fastIterator();
                            while (it.hasNext()) {
                                Object obj = it.next();
                                if (!(obj instanceof Feature)) continue;
                                Feature feat = (Feature)obj;
                                if (currentSelection.isSelected(feat)) {
                                    currentSelection.deselect(feat);
                                    continue;
                                }
                                currentSelection.select(feat);
                            }
                            break block8;
                        }
                        lyrVect.getDataStore().setSelection((DataSet)newSelection);
                    }
                    catch (Throwable throwable) {
                        DisposeUtils.dispose(newSelection);
                        throw throwable;
                    }
                }
                DisposeUtils.dispose((Disposable)newSelection);
            }
        }
        catch (DataException e) {
            throw new BehaviorException("No se pudo hacer la selecci\u00f3n", e);
        }
    }

    @Override
    public Image getImageCursor() {
        return IconThemeHelper.getImage("cursor-select-by-rectangle");
    }

    @Override
    public boolean cancelDrawing() {
        return false;
    }
}

