/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractConvertedTypeBand;

public class ConvertedTypeBandFloat
extends AbstractConvertedTypeBand
implements Band.BandFloat {
    public ConvertedTypeBandFloat(Buffer buffer, Band band) {
        super(buffer, band);
    }

    public float[] createRowBuffer() {
        return new float[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        for (int i = 0; i < this.getColumns(); ++i) {
            ((float[])rowBuffer)[i] = ((Number)this.band.get(row, i)).floatValue();
        }
    }

    public float getValue(int row, int column) {
        return ((Number)this.get(row, column)).floatValue();
    }

    public void setValue(int row, int column, float value) {
        this.doSet(row, column, new Float(value));
    }

    public int getDataType() {
        return 4;
    }

    public Object get(int row, int column) {
        return Float.valueOf(((Number)this.get(row, column)).floatValue());
    }

    @Override
    public NoData getNoData() {
        NoData bandNoData = this.band.getNoData();
        if (bandNoData == null) {
            this.noData = BufferLocator.getBufferManager().createNoData(null, null);
        } else {
            Float value = null;
            Float defaultValue = null;
            Number bandvalue = bandNoData.getValue();
            Number bandDefaultValue = bandNoData.getDefaultValue();
            if (bandvalue != null) {
                value = Float.valueOf(bandvalue.floatValue());
            }
            if (bandDefaultValue != null) {
                defaultValue = Float.valueOf(bandDefaultValue.floatValue());
            }
            this.noData = BufferLocator.getBufferManager().createNoData((Number)value, (Number)defaultValue);
        }
        return this.noData;
    }
}

