/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.impl.AbstractBuffer;
import org.gvsig.raster.lib.buffer.impl.exceptions.CreateBufferException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertedTypeBuffer
extends AbstractBuffer
implements Buffer {
    protected static final Logger logger = LoggerFactory.getLogger(ConvertedTypeBuffer.class);
    Buffer buffer;
    int type;

    public ConvertedTypeBuffer(Buffer buffer, int type) throws CreateBufferException {
        ToolsLocator.getDisposableManager().bind((Disposable)buffer);
        this.buffer = buffer;
        this.type = type;
        this.projection = buffer.getProjection();
        this.dimensions = buffer.getDimensions();
        this.bands = new ArrayList();
        try {
            this.createBands(this.buffer.getBands(), this.type);
        }
        catch (Exception e) {
            throw new CreateBufferException(e);
        }
    }

    private void createBands(Band[] bands, int type) throws BandException {
        BufferManager bufferManager = BufferLocator.getBufferManager();
        for (int i = 0; i < bands.length; ++i) {
            Band band = bufferManager.createConvertedTypeBand((Buffer)this, bands[i], type);
            this.bands.add(band);
            band.addObserver((Observer)this);
        }
    }

    @Override
    public void doDispose() throws BaseException {
        super.doDispose();
        DisposeUtils.dispose((Disposable)this.buffer);
        this.buffer = null;
    }

    public BufferedImage getBufferedImage() {
        return null;
    }
}

