/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.PageManager;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.impl.AbstractBuffer;
import org.gvsig.raster.lib.buffer.impl.exceptions.CreateBufferException;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuffer
extends AbstractBuffer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultBuffer.class);

    public DefaultBuffer(int rows, int columns, int[] bandDataTypes, NoData[] bandNoData, IProjection projection, Envelope envelope, List<PageManager> pageManagers) throws CreateBufferException {
        if (rows < 1) {
            try {
                throw new IllegalArgumentException("Can't create buffer with rows = " + rows);
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        if (columns < 1) {
            try {
                throw new IllegalArgumentException("Can't create buffer with columns = " + columns);
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        this.bands = new ArrayList();
        this.projection = projection;
        try {
            if (envelope == null) {
                GeometryManager geometryManager = GeometryLocator.getGeometryManager();
                envelope = geometryManager.createEnvelope(0.0, 0.0, (double)columns, (double)rows, 0);
            }
            this.dimensions = BufferLocator.getBufferManager().createBufferDimensions(rows, columns, envelope);
            if (bandDataTypes != null) {
                this.createBands(bandDataTypes, bandNoData, pageManagers);
            }
        }
        catch (Exception e) {
            throw new CreateBufferException(e);
        }
    }

    private void createBands(int[] bandDataTypes, NoData[] bandNoData, List<PageManager> pageManagers) throws BandException {
        BufferManager bufferManager = BufferLocator.getBufferManager();
        for (int i = 0; i < bandDataTypes.length; ++i) {
            NoData noDataBand = null;
            if (bandNoData != null && i < bandNoData.length) {
                noDataBand = bandNoData[i];
            }
            PageManager pageManager = null;
            if (pageManagers != null && i < pageManagers.size()) {
                pageManager = pageManagers.get(i);
            }
            Band band = bufferManager.createBand(bandDataTypes[i], this.getDimensions().getRows(), this.getDimensions().getColumns(), noDataBand, pageManager);
            this.bands.add(band);
            band.addObserver((Observer)this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Buffer cloned;
        try {
            cloned = BufferLocator.getBufferManager().createBuffer(this.getRows(), this.getColumns(), this.getBandTypes(), this.getBandNoData(), this.getProjection(), this.dimensions.getEnvelope());
        }
        catch (BufferException | LocatorException e) {
            throw new CloneNotSupportedException("Can't clone buffer.");
        }
        for (int i = 0; i < this.getBandCount(); ++i) {
            cloned.addBand((Band)this.getBand(i).clone());
        }
        return cloned;
    }

    public BufferedImage getBufferedImage() {
        int imageType;
        int[] bandTypes = this.getBandTypes();
        if (bandTypes.length < 3 || bandTypes.length > 4) {
            return null;
        }
        int type = bandTypes[0];
        if (type == 0) {
            imageType = bandTypes.length == 3 ? 5 : 6;
        } else {
            return null;
        }
        BufferedImage img = new BufferedImage(this.getColumns(), this.getRows(), imageType);
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getColumns(); ++column) {
                Color color = this.getBandCount() == 4 ? new Color(((Number)this.getBand(0).get(row, column)).intValue(), ((Number)this.getBand(1).get(row, column)).intValue(), ((Number)this.getBand(2).get(row, column)).intValue(), ((Number)this.getBand(3).get(row, column)).intValue()) : new Color(((Number)this.getBand(0).get(row, column)).intValue(), ((Number)this.getBand(1).get(row, column)).intValue(), ((Number)this.getBand(2).get(row, column)).intValue());
                img.setRGB(row, column, color.getRGB());
            }
        }
        return img;
    }
}

