/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;

public class DefaultBufferDimensions
implements BufferDimensions {
    protected int rows;
    protected int columns;
    protected Envelope envelope;
    private Double pixelSizeX = null;
    private Double pixelSizeY = null;

    public DefaultBufferDimensions(int rows, int columns, Envelope envelope) {
        this.rows = rows;
        this.columns = columns;
        this.envelope = envelope;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public double getPixelSizeX() {
        if (this.pixelSizeX == null) {
            this.pixelSizeX = this.getEnvelope().getLength(0) / (double)this.getColumns();
        }
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        if (this.pixelSizeY == null) {
            this.pixelSizeY = this.getEnvelope().getLength(1) / (double)this.getRows();
        }
        return this.pixelSizeY;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }
}

