/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Kernel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultKernel
implements Persistent,
Kernel {
    private double[][] kernel = null;
    private double divisor = 0.0;

    public DefaultKernel() {
    }

    public DefaultKernel(double[][] k) {
        this.kernel = k;
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                this.divisor += this.kernel[i][j];
            }
        }
    }

    public DefaultKernel(double[][] k, double divisor) {
        this.kernel = k;
        this.divisor = divisor;
    }

    public double[][] getKernel() {
        return this.kernel;
    }

    public double getDivisor() {
        return this.divisor;
    }

    public void setDivisor(double divisor) {
        this.divisor = divisor;
    }

    public int getSide() {
        return this.kernel.length;
    }

    public double kernelOperation(Kernel k) {
        double res = 0.0;
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                res += this.kernel[i][j] * k.getKernel()[i][j];
            }
        }
        return res;
    }

    public double convolution(Kernel k) {
        double res = this.kernelOperation(k);
        if (this.divisor != 0.0) {
            res /= this.divisor;
        }
        return res;
    }

    public void rgbNormalization() {
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                this.kernel[i][j] = (byte)this.kernel[i][j] & 0xFF;
            }
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        int side = state.getInt("side");
        this.kernel = new double[side][side];
        if (side >= 3) {
            this.kernel[0] = state.getDoubleArray("row_0");
            this.kernel[1] = state.getDoubleArray("row_1");
            this.kernel[2] = state.getDoubleArray("row_2");
        }
        if (side >= 5) {
            this.kernel[3] = state.getDoubleArray("row_3");
            this.kernel[4] = state.getDoubleArray("row_4");
        }
        if (side >= 7) {
            this.kernel[5] = state.getDoubleArray("row_5");
            this.kernel[6] = state.getDoubleArray("row_6");
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        if (this.kernel == null) {
            return;
        }
        state.set("row_0", this.kernel[0]);
        state.set("row_1", this.kernel[1]);
        state.set("row_2", this.kernel[2]);
        if (this.kernel.length == 3) {
            state.set("side", 3);
            return;
        }
        state.set("row_3", this.kernel[3]);
        state.set("row_4", this.kernel[4]);
        if (this.kernel.length == 5) {
            state.set("side", 5);
            return;
        }
        state.set("row_5", this.kernel[5]);
        state.set("row_6", this.kernel[6]);
        if (this.kernel.length == 7) {
            state.set("side", 7);
            return;
        }
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("Kernel_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(DefaultKernel.class, "Kernel_Persistent", "Kernel Persistency", null, null);
        }
        definition.addDynFieldInt("side").setMandatory(false);
        definition.addDynFieldList("row_0").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("row_1").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("row_2").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("row_3").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("row_4").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("row_5").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("row_6").setClassOfItems(Double.TYPE).setMandatory(false);
    }
}

