/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandTileManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractTiledBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;

public class TiledBandByte
extends AbstractTiledBand
implements Band.BandByte {
    public TiledBandByte(int rows, int columns, NoData noData, BandTileManager tileManager) {
        super(rows, columns, noData, tileManager);
        this.data = ByteBuffer.allocate(this.calculateBufferSizeToAllocate(rows, columns));
    }

    public int getDataType() {
        return 0;
    }

    @Override
    protected int getDataSize() {
        return 1;
    }

    public Object get(int row, int column) {
        return this.getValue(row, column);
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.setValue(row, column, (Byte)value);
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        for (int row = 0; row < this.rows; row += this.rowsInTile) {
            for (int column = 0; column < this.columns; column += this.columnsInTile) {
                this.loadTile(row, column);
                Arrays.fill((byte[])this.data.array(), (Byte)value);
            }
        }
    }

    public byte getValue(int row, int column) {
        this.loadTile(row, column);
        return ((ByteBuffer)this.data).get((row - this.firstRowOfTile) * this.columnsInTile + (column - this.firstColumnOfTile));
    }

    public void setValue(int row, int column, byte value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, value}));
    }

    protected void doSetValue(int row, int column, byte value) {
        this.loadTile(row, column);
        ((ByteBuffer)this.data).put((row - this.firstRowOfTile) * this.columnsInTile + (column - this.firstColumnOfTile), value);
    }

    public byte[] createRowBuffer() {
        return new byte[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        byte[] target = (byte[])rowBuffer;
        for (int column = 0; column < this.columns; column += this.columnsInTile) {
            this.loadTile(row, column);
            byte[] source = (byte[])this.data.array();
            System.arraycopy(source, (row - this.firstRowOfTile) * this.columnsInTile, target, column, this.columnsInTile);
        }
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        byte[] source = (byte[])rowBuffer;
        for (int column = 0; column < this.columns; column += this.columnsInTile) {
            this.loadTile(row, column);
            byte[] target = (byte[])this.data.array();
            System.arraycopy(source, column, target, (row - this.firstRowOfTile) * this.columnsInTile, this.columnsInTile);
        }
    }
}

