/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.operations.tailtrim;

import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractSpecifiedBandsOperation;
import org.gvsig.tools.locator.LocatorException;

public class TailTrimOperation
extends AbstractSpecifiedBandsOperation {
    public static String STATISTICS_PARAM = "statistics";
    public static String TAIL_TRIM_PERCENT_PARAM = "tail_trim_percent";
    private Statistics statistics;
    private double tailTrimPercent;
    private RowProcessor[] rowProcessors;

    public TailTrimOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        this.statistics = (Statistics)this.getParameter(STATISTICS_PARAM, null);
        if (this.statistics == null) {
            this.statistics = this.getInputBuffer().getStatistics(null);
        }
        this.tailTrimPercent = (Double)this.getParameter(TAIL_TRIM_PERCENT_PARAM, 0);
        this.tailTrimPercent = this.tailTrimPercent > 100.0 ? 100.0 : this.tailTrimPercent;
        this.tailTrimPercent = this.tailTrimPercent < 0.0 ? 0.0 : this.tailTrimPercent;
        int bands = this.getInputBuffer().getBandCount();
        this.rowProcessors = new RowProcessor[bands];
        int[] bandTypes = new int[bands];
        for (int i = 0; i < bandTypes.length; ++i) {
            bandTypes[i] = this.getInputBuffer().getBandTypes()[i];
        }
        NoData[] noData = this.getInputBuffer().getBandNoData();
        NoData[] resultNoData = new NoData[noData.length];
        block11: for (int band = 0; band < noData.length; ++band) {
            int bandType = this.getInputBuffer().getBand(band).getDataType();
            switch (bandType) {
                case 0: {
                    this.rowProcessors[band] = new ByteRowProcessor(band);
                    if (!this.isProcessableBand(band)) continue block11;
                    if (noData[band].isDefined()) {
                        resultNoData[band] = noData[band];
                        continue block11;
                    }
                    resultNoData[band] = manager.createNoData((Number)0, (Number)0);
                    continue block11;
                }
                case 1: {
                    this.rowProcessors[band] = new UShortRowProcessor(band);
                    if (!this.isProcessableBand(band)) continue block11;
                    if (noData[band].isDefined()) {
                        resultNoData[band] = noData[band];
                        continue block11;
                    }
                    resultNoData[band] = manager.createNoData((Number)0, (Number)0);
                    continue block11;
                }
                case 2: {
                    this.rowProcessors[band] = new ShortRowProcessor(band);
                    if (!this.isProcessableBand(band)) continue block11;
                    if (noData[band].isDefined()) {
                        resultNoData[band] = noData[band];
                        continue block11;
                    }
                    resultNoData[band] = manager.createNoData((Number)Short.MIN_VALUE, (Number)Short.MIN_VALUE);
                    continue block11;
                }
                case 3: {
                    this.rowProcessors[band] = new IntRowProcessor(band);
                    if (!this.isProcessableBand(band)) continue block11;
                    if (noData[band].isDefined()) {
                        resultNoData[band] = noData[band];
                        continue block11;
                    }
                    resultNoData[band] = manager.createNoData((Number)Integer.MIN_VALUE, (Number)Integer.MIN_VALUE);
                    continue block11;
                }
                case 4: {
                    this.rowProcessors[band] = new FloatRowProcessor(band);
                    if (!this.isProcessableBand(band)) continue block11;
                    if (noData[band].isDefined()) {
                        resultNoData[band] = noData[band];
                        continue block11;
                    }
                    resultNoData[band] = manager.createNoData((Number)Float.valueOf(Float.MIN_VALUE), (Number)Float.valueOf(Float.MIN_VALUE));
                    continue block11;
                }
                case 5: {
                    this.rowProcessors[band] = new DoubleRowProcessor(band);
                    if (!this.isProcessableBand(band)) continue block11;
                    if (noData[band].isDefined()) {
                        resultNoData[band] = noData[band];
                        continue block11;
                    }
                    resultNoData[band] = manager.createNoData((Number)Double.MIN_VALUE, (Number)Double.MIN_VALUE);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Unknow type of band '" + band + "'");
                }
            }
        }
        try {
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), bandTypes, resultNoData, this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new BufferOperationException(e);
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        for (int band = 0; band < this.getInputBuffer().getBandCount(); ++band) {
            if (this.getBandsToProcess().contains(band)) {
                Band bufferBand = this.getInputBuffer().getBand(band);
                Band outputBufferBand = this.getOutputBuffer().getBand(band);
                for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                    Object rowBuffer = bufferBand.createRowBuffer();
                    bufferBand.fetchRow(row, rowBuffer);
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    outputBufferBand.fetchRow(row, outputRowBuffer);
                    this.rowProcessors[band].processRow(rowBuffer, outputRowBuffer);
                    outputBufferBand.putRow(row, outputRowBuffer);
                }
                continue;
            }
            try {
                this.getOutputBuffer().getBand(band).copyFrom(this.getInputBuffer().getBand(band));
                continue;
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private class DoubleRowProcessor
    extends AbstractRowProcessor {
        public DoubleRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            double[] inputByteRow = (double[])inputRow;
            double[] outputByteRow = (double[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]).doubleValue();
            }
        }

        @Override
        public Number processValue(Number value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            double fValue = value.doubleValue();
            if (fValue < this.minValue || fValue > this.maxValue) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            return value;
        }
    }

    private class FloatRowProcessor
    extends AbstractRowProcessor {
        public FloatRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            float[] inputFloatRow = (float[])inputRow;
            float[] outputFloatRow = (float[])outputRow;
            for (int i = 0; i < inputFloatRow.length; ++i) {
                outputFloatRow[i] = this.processValue(Float.valueOf(inputFloatRow[i])).floatValue();
            }
        }

        @Override
        public Number processValue(Number value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            float fValue = value.floatValue();
            if ((double)fValue < this.minValue || (double)fValue > this.maxValue) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            return value;
        }
    }

    private class IntRowProcessor
    extends AbstractRowProcessor {
        public IntRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            int[] inputByteRow = (int[])inputRow;
            int[] outputByteRow = (int[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]).intValue();
            }
        }

        @Override
        public Number processValue(Number value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            int iValue = value.intValue();
            if ((double)iValue < this.minValue || (double)iValue > this.maxValue) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            return value;
        }
    }

    private class UShortRowProcessor
    extends AbstractRowProcessor {
        public UShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            short[] inputShortRow = (short[])inputRow;
            short[] outputShortRow = (short[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                outputShortRow[i] = this.processValue(inputShortRow[i]).shortValue();
            }
        }

        @Override
        public Number processValue(Number value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            int iValue = 0xFFFF & (Short)value;
            if ((double)iValue < this.minValue || (double)iValue > this.maxValue) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            return value;
        }
    }

    private class ShortRowProcessor
    extends AbstractRowProcessor {
        public ShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            short[] inputShortRow = (short[])inputRow;
            short[] outputShortRow = (short[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                outputShortRow[i] = this.processValue(inputShortRow[i]).shortValue();
            }
        }

        @Override
        public Number processValue(Number value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            short iValue = (Short)value;
            if ((double)iValue < this.minValue || (double)iValue > this.maxValue) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            return value;
        }
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        public ByteRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            byte[] inputByteRow = (byte[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]).byteValue();
            }
        }

        @Override
        public Number processValue(Number value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            int iValue = 0xFF & (Byte)value;
            if ((double)iValue < this.minValue || (double)iValue > this.maxValue) {
                return TailTrimOperation.this.getOutputBuffer().getBand(this.band).getNoData().getValue();
            }
            return value;
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        int band;
        double minValue;
        double maxValue;
        NoData noData;

        public AbstractRowProcessor(int band) {
            this.band = band;
            this.noData = TailTrimOperation.this.getInputBuffer().getBand(band).getNoData();
            double[][] tailTrim = TailTrimOperation.this.statistics.getTailTrimValue(TailTrimOperation.this.tailTrimPercent);
            this.minValue = tailTrim[this.band][0];
            this.maxValue = tailTrim[this.band][1];
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, Object var2);

        public Number processValue(Number var1);
    }
}

