/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl;

import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.VCSGisUserIdentificationRequester;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisJAddToWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJBackupHistory;
import org.gvsig.vcsgis.swing.VCSGisJChanges;
import org.gvsig.vcsgis.swing.VCSGisJCheckout;
import org.gvsig.vcsgis.swing.VCSGisJCheckoutDataModel;
import org.gvsig.vcsgis.swing.VCSGisJCreateResourceTable;
import org.gvsig.vcsgis.swing.VCSGisJDownloadWorkingcopy;
import org.gvsig.vcsgis.swing.VCSGisJExport;
import org.gvsig.vcsgis.swing.VCSGisJImportHistory;
import org.gvsig.vcsgis.swing.VCSGisJInitServer;
import org.gvsig.vcsgis.swing.VCSGisJInitWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJLog;
import org.gvsig.vcsgis.swing.VCSGisJLogout;
import org.gvsig.vcsgis.swing.VCSGisJPrepareWorkingcopy;
import org.gvsig.vcsgis.swing.VCSGisJRegisterWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJRestoreHistory;
import org.gvsig.vcsgis.swing.VCSGisJRevisions;
import org.gvsig.vcsgis.swing.VCSGisJSetWorkingCopyOffline;
import org.gvsig.vcsgis.swing.VCSGisJShowServerTableForm;
import org.gvsig.vcsgis.swing.VCSGisPanel;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisEntitySelectorControllerJComboBox;
import org.gvsig.vcsgis.swing.impl.VCSGisEntitySelectorControllerJList;
import org.gvsig.vcsgis.swing.impl.VCSGisEntitySelectorControllerJTree;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSWorkspacePickerControllerImpl;
import org.gvsig.vcsgis.swing.impl.addToWorkspace.VCSGisJAddToWorkspaceImpl;
import org.gvsig.vcsgis.swing.impl.changes.TopologyPlansExecutor;
import org.gvsig.vcsgis.swing.impl.changes.VCSGisJChangesImpl;
import org.gvsig.vcsgis.swing.impl.checkout.VCSGisJCheckoutImpl;
import org.gvsig.vcsgis.swing.impl.checkoutDataModel.VCSGisJCheckoutDataModelImpl;
import org.gvsig.vcsgis.swing.impl.downloadworkspace.DownloadWorkingcopyImpl;
import org.gvsig.vcsgis.swing.impl.export.VCSGisJExportImpl;
import org.gvsig.vcsgis.swing.impl.importhistory.ImportHistoryImpl;
import org.gvsig.vcsgis.swing.impl.initserver.VCSGisJInitServerImpl;
import org.gvsig.vcsgis.swing.impl.initworkspace.VCSGisJInitWorkspaceImpl;
import org.gvsig.vcsgis.swing.impl.log.VCSGisJLogImpl;
import org.gvsig.vcsgis.swing.impl.loggin.VCSGisUserIdentificationRequesterDialog;
import org.gvsig.vcsgis.swing.impl.logout.VCSGisJLogoutImpl;
import org.gvsig.vcsgis.swing.impl.managehistory.VCSGisJBackupHistoryImpl;
import org.gvsig.vcsgis.swing.impl.managehistory.VCSGisJRestoreHistoryImpl;
import org.gvsig.vcsgis.swing.impl.prepareworkspace.PrepareWorkspaceImpl;
import org.gvsig.vcsgis.swing.impl.registerWorkspace.VCSGisJRegisterWorkspaceImpl;
import org.gvsig.vcsgis.swing.impl.registrationOfEditingStores.VCSGisJRegistrationOfEditingStoresImpl;
import org.gvsig.vcsgis.swing.impl.repoEntitiyFeatureTypeEditor.RepositoryEntityFeatureTypeEditorImpl;
import org.gvsig.vcsgis.swing.impl.resourceTable.VCSGisJCreateResourceTableImpl;
import org.gvsig.vcsgis.swing.impl.revisions.VCSGisJRevisionsImpl;
import org.gvsig.vcsgis.swing.impl.setWorkingCopyOffline.VCSGisJSetWorkingCopyOfflineImpl;
import org.gvsig.vcsgis.swing.impl.showServerTableForm.VCSGisJShowServerTableFormImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisSwingManagerImpl
implements VCSGisSwingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisSwingManagerImpl.class);
    public static final String ICON_COMMON_GROUP_NAME = "common";
    public static final String ICON_GROUP_NAME = "vcsgis";
    public static final String ICON_PROVIDER_NAME = "VCSGis";
    private VCSGisSwingServices services;
    private boolean emptyEffectiveDateAllowed = false;
    private boolean currentDateAsEffectiveDateByDefault = true;
    private int repositoryEntityFeatureTypeEditorMode = 0;

    public VCSGisSwingManagerImpl() {
        VCSGisLocator.getVCSGisManager().setUserIdentificationRequester((VCSGisUserIdentificationRequester)new VCSGisUserIdentificationRequesterDialog());
    }

    public static void registerIcons(String[][] iconsInfo) {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        for (String[] icon : iconsInfo) {
            URL url = VCSGisSwingManagerImpl.class.getResource("images/" + icon[2] + ".png");
            theme.registerDefault(icon[0], icon[1], icon[2], null, url);
        }
    }

    public static ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = VCSGisSwingManagerImpl.class.getResource("images/" + name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public VCSGisJChanges createChangesPanel() {
        return new VCSGisJChangesImpl();
    }

    public VCSGisJChanges createChangesPanel(VCSGisWorkspace workspace, List<String> tableNames, Timestamp efectivedate, String comment) {
        return new VCSGisJChangesImpl(workspace, tableNames, efectivedate, comment);
    }

    public PickerController<VCSGisWorkspace> createPickerWorkspaceController(JComboBox combo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public VCSGisJInitServer createInitRepositoryPanel() {
        return new VCSGisJInitServerImpl();
    }

    public VCSGisJInitWorkspace createInitWorkspacePanel() {
        return new VCSGisJInitWorkspaceImpl();
    }

    public VCSGisJAddToWorkspace createAddToWorkspacePanel() {
        return new VCSGisJAddToWorkspaceImpl();
    }

    public VCSGisJCheckout createCheckoutPanel() {
        return new VCSGisJCheckoutImpl();
    }

    public VCSGisJCheckout createCheckoutPanel(VCSGisWorkspace workspace, List<String> tableNames, Boolean overwrite) {
        return new VCSGisJCheckoutImpl(workspace, tableNames, overwrite);
    }

    public VCSGisJCheckoutDataModel createCheckoutDataModelPanel() {
        return new VCSGisJCheckoutDataModelImpl();
    }

    public VCSGisJCheckoutDataModel createCheckoutDataModelPanel(VCSGisWorkspace workspace, String model) {
        return new VCSGisJCheckoutDataModelImpl(workspace, model);
    }

    public VCSGisJExport createExportPanel() {
        return new VCSGisJExportImpl();
    }

    public void setDefaultServices(VCSGisSwingServices services) {
        this.services = services;
    }

    public VCSGisSwingServices getDefaultServices() {
        return this.services;
    }

    public PickerController<VCSGisWorkspace> createWorkspacePickerController(JComboBox combo, JButton button) {
        return new VCSWorkspacePickerControllerImpl(combo, button);
    }

    public VCSGisJRegisterWorkspace createRegisterWorkspacePanel() {
        return new VCSGisJRegisterWorkspaceImpl();
    }

    public VCSGisJShowServerTableForm createShowTableServerFormPanel(String tableName) {
        return new VCSGisJShowServerTableFormImpl(tableName);
    }

    public String getHTMLColoredForEntity(VCSGisWorkspaceEntity entity, String name) {
        return this.getHTMLColoredForEntity(entity, name, 0);
    }

    public String getHTMLColoredForEntity(VCSGisWorkspaceEntity entity, String name, int defaultState) {
        return VCSGisSwingCommons.getHTMLColorTag(entity == null ? defaultState : entity.getState(), name);
    }

    public VCSGisJRevisions createRevisionsPanel() {
        return new VCSGisJRevisionsImpl();
    }

    public VCSGisJImportHistory createImportHistoryPanel() {
        return new ImportHistoryImpl();
    }

    public VCSGisJCreateResourceTable createResourceTablePanel() {
        return new VCSGisJCreateResourceTableImpl();
    }

    public VCSGisJLogout createLogoutPanel() {
        return new VCSGisJLogoutImpl();
    }

    public VCSGisEntitySelectorController createEntitySelectorController(JList lstTables, JTextComponent txtFilter, JButton btnTable, JButton btnCheckAll, JButton btnUnCheckAll) {
        return new VCSGisEntitySelectorControllerJList(lstTables, txtFilter, btnTable, btnCheckAll, btnUnCheckAll);
    }

    public VCSGisEntitySelectorController createEntitySelectorController(JList lstTables, JTextComponent txtFilter, JButton btnTable) {
        return new VCSGisEntitySelectorControllerJList(lstTables, txtFilter, btnTable, null, null);
    }

    public VCSGisEntitySelectorController createEntitySelectorController(JList lstTables) {
        return new VCSGisEntitySelectorControllerJList(lstTables, null, null, null, null);
    }

    public VCSGisEntitySelectorController createEntitySelectorController(JComboBox cboTables) {
        return new VCSGisEntitySelectorControllerJComboBox(cboTables);
    }

    public VCSGisEntitySelectorController createEntitySelectorController(JTree treeEntities, JTextComponent txtFilter, JButton btnTable, JButton btnCheckAll, JButton btnUnCheckAll) {
        return new VCSGisEntitySelectorControllerJTree(treeEntities, txtFilter, btnTable, btnCheckAll, btnUnCheckAll);
    }

    public VCSGisEntitySelectorController createEntitySelectorController(JTree treeEntities, JTextComponent txtFilter, JButton btnTable) {
        return new VCSGisEntitySelectorControllerJTree(treeEntities, txtFilter, btnTable, null, null);
    }

    public VCSGisEntitySelectorController createEntitySelectorController(JTree treeEntities) {
        return new VCSGisEntitySelectorControllerJTree(treeEntities, null, null, null, null);
    }

    public VCSGisJDownloadWorkingcopy createDownloadWorkingcopyPanel() {
        return new DownloadWorkingcopyImpl();
    }

    public boolean executeTopologyPlan(VCSGisWorkspace ws, VCSGisEntity entity, boolean autoclose) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity can't be null.");
        }
        VCSGisTopologyPlan topologyPlan = ws.getTopologyPlan(entity.getTopologyPlanCode());
        if (topologyPlan == null || StringUtils.isBlank((CharSequence)topologyPlan.getData())) {
            return true;
        }
        try {
            TopologyPlansExecutor executor = new TopologyPlansExecutor();
            ArrayList<VCSGisTopologyPlanStatus> status = new ArrayList<VCSGisTopologyPlanStatus>();
            boolean x = executor.execute(ws, Collections.singletonList(entity), status, autoclose);
            if (!x) {
                return false;
            }
            return ((VCSGisTopologyPlanStatus)status.get(0)).isPassed();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't execute topology plan for '" + entity.getEntityName() + "'.", (Throwable)ex);
            return false;
        }
    }

    public VCSGisJPrepareWorkingcopy createPrepareWorkingcopyPanel() {
        return new PrepareWorkspaceImpl();
    }

    public VCSGisJBackupHistory createBackupHistoryPanel() {
        return new VCSGisJBackupHistoryImpl();
    }

    public VCSGisJRestoreHistory createRestoreHistoryPanel() {
        return new VCSGisJRestoreHistoryImpl();
    }

    public VCSGisPanel createRegistrationOfEditingStoresPanel() {
        return new VCSGisJRegistrationOfEditingStoresImpl();
    }

    public VCSGisPanel createRepositoryEntityFeatureTypeEditor() {
        return new RepositoryEntityFeatureTypeEditorImpl();
    }

    public boolean isEmptyEffectiveDateAllowed() {
        return this.emptyEffectiveDateAllowed;
    }

    public boolean useCurrentDateAsEffectiveDateByDefault() {
        return this.currentDateAsEffectiveDateByDefault;
    }

    public void setCurrentDateAsEffectiveDateByDefault(boolean currentDateAsEffectiveDateByDefault) {
        this.currentDateAsEffectiveDateByDefault = currentDateAsEffectiveDateByDefault;
    }

    public void setEmptyEffectiveDateAllowed(boolean emptyEffectiveDateAllowed) {
        this.emptyEffectiveDateAllowed = emptyEffectiveDateAllowed;
    }

    public void setRepositoryEntityFeatureTypeEditorMode(int value) {
        this.repositoryEntityFeatureTypeEditorMode = value;
    }

    public boolean getEmptyEffectiveDateAllowed() {
        return this.emptyEffectiveDateAllowed;
    }

    public boolean getCurrentDateAsEffectiveDateByDefault() {
        return this.currentDateAsEffectiveDateByDefault;
    }

    public int getRepositoryEntityFeatureTypeEditorMode() {
        return this.repositoryEntityFeatureTypeEditorMode;
    }

    public VCSGisJLog createLogPanel() {
        return new VCSGisJLogImpl();
    }

    public VCSGisJSetWorkingCopyOffline createSetWorkingCopyOfflinePanel() {
        return new VCSGisJSetWorkingCopyOfflineImpl();
    }
}

