/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.importhistory;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.impl.importhistory.ImportProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImportProcess
implements ImportProcess {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractImportProcess.class);
    protected static final int NUMBER_OF_INSERTS_TO_CHANGE_TO_APPEND_MODE = 20;
    protected final VCSGisWorkspace workspace;
    protected final FeatureStore sourceStore;
    protected final VCSGisEntity targetEntity;
    protected final String fieldCodeName;
    protected final String fieldOrderName;
    protected final boolean sortOrder;
    protected final Expression deletedCondition;
    protected final SimpleTaskStatus status;
    protected final List<String> entityCodes;
    protected final List<VCSGisEntity> entities;
    protected final FeatureSymbolTable deletedConditionSymbolTable;
    private FeatureStore targetStore;
    private FeatureType sourceFeatureType;
    private FeatureType targetFeatureType;
    private FeatureAttributeDescriptor sourceAttrCodeName;
    private FeatureAttributeDescriptor targetAttrCodeName;
    private String targetFieldCodeName;
    private String sourceFieldCodeName;
    protected long sourceSize = -1L;
    private long currentRecord = -1L;
    private long startTime = -1L;
    private long lastRemainingEstimatedTime = -1L;
    private long totalTime = -1L;
    private final boolean onlyLocal;
    private long commitCounter;
    private File logFile = null;
    private boolean hasDuplicatedDeletes = false;
    private boolean hasErrors;
    private final MutableSymbolTable parentDeletedConditionSymbolTable;
    private String estimated_time_label = null;
    private static final int BLOCK_SIZE_FOR_THE_TIME_ESTIMATE = 1000;
    private long[] startTimes = new long[1000];

    protected AbstractImportProcess(boolean onlyLocal, VCSGisWorkspace workspace, FeatureStore sourceStore, VCSGisEntity targetEntity, String fieldCodeName, String fieldOrderName, String sortOrder, Expression deletedCondition, SimpleTaskStatus status) {
        this.onlyLocal = onlyLocal;
        this.targetStore = null;
        this.workspace = workspace;
        this.sourceStore = sourceStore;
        this.targetEntity = targetEntity;
        this.fieldCodeName = fieldCodeName;
        this.fieldOrderName = fieldOrderName;
        this.sortOrder = sortOrder == null ? true : sortOrder.equalsIgnoreCase("asc");
        this.deletedCondition = deletedCondition;
        this.status = status;
        this.entityCodes = Collections.singletonList(targetEntity.getEntityCode());
        this.entities = Collections.singletonList(targetEntity);
        this.deletedConditionSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
        this.parentDeletedConditionSymbolTable = this.deletedConditionSymbolTable.createParent();
    }

    protected abstract FeatureQuery getSourceQuery() throws DataException;

    protected void update_estimated_time() {
        if (this.sourceSize < 0L) {
            return;
        }
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis() / 1000L;
        }
        ++this.currentRecord;
        long currentTime = System.currentTimeMillis() / 1000L;
        int currentRecordBlock = (int)(this.currentRecord % 1000L);
        this.startTimes[currentRecordBlock] = currentTime;
        if (this.currentRecord < 300L) {
            return;
        }
        long elapsedTime = currentTime - this.startTime;
        long totalEstimatedTime = elapsedTime * this.sourceSize / this.currentRecord;
        long remainingEstimatedTime = totalEstimatedTime - elapsedTime;
        long startTimeB = this.startTimes[currentRecordBlock >= 999 ? 0 : currentRecordBlock + 1];
        if (startTimeB > 0L) {
            double elapsedTimeB = currentTime - startTimeB;
            double elapsedTimeOne = elapsedTimeB / 1000.0;
            remainingEstimatedTime = (long)(elapsedTimeOne * (double)(this.sourceSize - this.currentRecord));
        }
        if (this.lastRemainingEstimatedTime == remainingEstimatedTime) {
            return;
        }
        if (this.estimated_time_label == null) {
            this.estimated_time_label = " (" + ToolsLocator.getI18nManager().getTranslation("_Estimated_time_remaining");
        }
        this.lastRemainingEstimatedTime = remainingEstimatedTime;
        String tit = this.status.getTitle();
        int n = StringUtils.indexOf((CharSequence)tit, (CharSequence)this.estimated_time_label);
        if (n > 0) {
            tit = StringUtils.left((String)tit, (int)n);
        }
        tit = tit + this.estimated_time_label + " " + this.formatTime(remainingEstimatedTime) + ")";
        this.status.setTitle(tit);
    }

    protected FeatureStore getTargetStore() {
        if (this.targetStore == null) {
            this.targetStore = this.workspace.openFeatureStore(this.targetEntity.getEntityName(), false);
        }
        return this.targetStore;
    }

    protected FeatureType getSourceFeatureType() throws DataException {
        if (this.sourceFeatureType == null) {
            this.sourceFeatureType = this.sourceStore.getDefaultFeatureType();
        }
        return this.sourceFeatureType;
    }

    protected FeatureType getTargetFeatureType() throws DataException {
        if (this.targetFeatureType == null) {
            this.targetFeatureType = this.getTargetStore().getDefaultFeatureType();
        }
        return this.targetFeatureType;
    }

    protected FeatureAttributeDescriptor getSourceAttrCodeName() throws DataException {
        this.sourceAttrCodeName = this.getSourceFeatureType().getAttributeDescriptor(this.fieldCodeName);
        if (this.sourceAttrCodeName == null) {
            throw new IllegalArgumentException("Field '" + this.fieldCodeName + "' (fieldCodeName) has not been found in the source table.");
        }
        return this.sourceAttrCodeName;
    }

    protected FeatureAttributeDescriptor getTargetAttrCodeName() throws DataException {
        this.targetAttrCodeName = this.getTargetFeatureType().getAttributeDescriptor(this.fieldCodeName);
        if (this.targetAttrCodeName == null) {
            throw new IllegalArgumentException("Field '" + this.fieldCodeName + "' (fieldCodeName) has not been found in the target table.");
        }
        return this.targetAttrCodeName;
    }

    public int checkParameters() {
        if (this.sourceStore == null) {
            LOGGER.warn("sourceStore can't be null,");
            return 25;
        }
        if (this.workspace == null) {
            LOGGER.warn("workspace can't be null,");
            return 25;
        }
        if (this.targetEntity == null) {
            LOGGER.warn("targetEntity can't be null,");
            return 25;
        }
        if (this.status == null) {
            LOGGER.warn("status can't be null,");
            return 25;
        }
        if (StringUtils.isBlank((CharSequence)this.fieldCodeName)) {
            LOGGER.warn("fieldCodeName can't be blank,");
            return 25;
        }
        return 0;
    }

    public String getTargetFieldCodeName() throws DataException {
        if (this.targetFieldCodeName == null) {
            this.targetFieldCodeName = this.getTargetAttrCodeName().getName();
        }
        return this.targetFieldCodeName;
    }

    public String getSourceFieldCodeName() throws DataException {
        if (this.sourceFieldCodeName == null) {
            this.sourceFieldCodeName = this.getSourceAttrCodeName().getName();
        }
        return this.sourceFieldCodeName;
    }

    public String getSourceFieldOrderName() throws DataException {
        if (StringUtils.isBlank((CharSequence)this.fieldOrderName)) {
            return null;
        }
        return this.getSourceFeatureType().getAttributeDescriptor(this.fieldOrderName).getName();
    }

    protected long getDateDiff(Timestamp date1, Timestamp date2, ChronoUnit unit) {
        long x = unit.between(date1.toLocalDateTime(), date2.toLocalDateTime());
        return x;
    }

    protected boolean haveToDelete(Feature feature) {
        if (ExpressionUtils.isEmpty((Expression)this.deletedCondition)) {
            return false;
        }
        this.deletedConditionSymbolTable.setFeature(feature);
        Object n = this.deletedCondition.execute((SymbolTable)this.parentDeletedConditionSymbolTable);
        boolean delete = DataTypeUtils.toBoolean((Object)n, (boolean)false);
        return delete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int commit(Timestamp revisionDate, Timestamp efectiveDate) {
        int result;
        ++this.commitCounter;
        if (this.onlyLocal) {
            return 0;
        }
        this.status.push();
        try {
            result = this.workspace.commit(this.entityCodes, revisionDate, efectiveDate, null, this.status, null);
        }
        finally {
            this.status.pop();
        }
        return result;
    }

    protected void disposeTargetStore() {
        DisposeUtils.dispose((Disposable)this.targetStore);
        this.targetStore = null;
        if (this.totalTime <= 0L) {
            long currentTime = System.currentTimeMillis() / 1000L;
            this.totalTime = currentTime - this.startTime;
        }
    }

    protected boolean changeToAppendMode(FeatureStore store, long insertionCounter) throws DataException {
        switch (store.getMode()) {
            case 0: {
                store.edit(2);
                return true;
            }
            case 1: {
                store.finishEditing();
                store.edit(2);
                return true;
            }
            case 3: {
                if (insertionCounter <= 20L) break;
                store.finishEditing();
                store.edit(2);
                return true;
            }
        }
        return false;
    }

    protected boolean changeToPassThroughMode(FeatureStore store) throws DataException {
        switch (this.targetStore.getMode()) {
            case 0: {
                this.targetStore.edit(3);
                return true;
            }
            case 1: 
            case 2: {
                this.targetStore.finishEditing();
                this.targetStore.edit(3);
                return true;
            }
        }
        return false;
    }

    @Override
    public long getTotalCommits() {
        return this.commitCounter;
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public String getTotalTimeFormatted() {
        return this.formatTime(this.totalTime);
    }

    public String formatTime(long t) {
        String s;
        if (t > 3600L) {
            long h = t / 3600L;
            long min = (t - h * 3600L) / 60L;
            s = h + "h " + min + "m";
        } else if (t > 60L) {
            long min = t / 60L;
            s = min + "m";
        } else {
            long sec = t;
            s = sec + "s";
        }
        return s;
    }

    protected void dumpRepositoryConnectionInfo() {
    }

    protected GroupBy createGroupByRevisionDate(final String fieldDateName, final ChronoUnit groupEveryUnit, final long groupEvery) {
        GroupBy groupby = new GroupBy(){
            private Timestamp firstRevisionDateOfGroup = null;

            @Override
            public boolean isEndOfGroup(Feature feature) {
                Timestamp currentRevisionDate = feature.getTimestamp(fieldDateName);
                if (this.firstRevisionDateOfGroup == null) {
                    this.firstRevisionDateOfGroup = currentRevisionDate;
                    return false;
                }
                return AbstractImportProcess.this.getDateDiff(this.firstRevisionDateOfGroup, currentRevisionDate, groupEveryUnit) >= groupEvery;
            }

            @Override
            public void next(Feature feature) {
                if (this.isEndOfGroup(feature)) {
                    this.firstRevisionDateOfGroup = feature.getTimestamp(fieldDateName);
                }
            }

            @Override
            public String getGroupLabel() {
                return Objects.toString(this.firstRevisionDateOfGroup);
            }
        };
        return groupby;
    }

    protected GroupBy createGroupByRevisionNumber(final String sourceFieldRevisionName) {
        GroupBy groupby = new GroupBy(){
            private Number lastRevision = null;

            @Override
            public boolean isEndOfGroup(Feature feature) {
                Number currentRevision = (Number)feature.get(sourceFieldRevisionName);
                if (this.lastRevision == null) {
                    this.lastRevision = currentRevision;
                    return false;
                }
                return !this.lastRevision.equals(currentRevision);
            }

            @Override
            public void next(Feature feature) {
                Number currentRevision;
                this.lastRevision = currentRevision = (Number)feature.get(sourceFieldRevisionName);
            }

            @Override
            public String getGroupLabel() {
                return Objects.toString(this.lastRevision);
            }
        };
        return groupby;
    }

    protected int process_minimize_time(FeatureSet sourceFeatures, GroupBy groupby, String sourceFieldEfectiveDateName, Set<Object> inserteds) throws Exception {
        return this.process_minimize_time2(sourceFeatures, groupby, sourceFieldEfectiveDateName, inserteds);
    }

    protected int process_minimize_memory(FeatureSet sourceFeatures, GroupBy groupby, boolean requireEfectiveDate, String sourceFieldEfectiveDateName) throws Exception {
        return this.process_minimize_memory2(sourceFeatures, groupby, requireEfectiveDate, sourceFieldEfectiveDateName);
    }

    protected int process_minimize_time2(FeatureSet sourceFeatures, GroupBy groupby, String sourceFieldEfectiveDateName, Set<Object> inserteds) throws Exception {
        Timestamp efectiveDate = null;
        ExpressionBuilder expBuilder = ExpressionUtils.createExpressionBuilder();
        this.getTargetStore().edit(1);
        try {
            this.status.message("Copying data...");
            for (Feature sourceFeature : sourceFeatures) {
                this.update_estimated_time();
                if (this.status.isCancellationRequested()) {
                    this.status.cancel();
                    FeatureStore.cancelEditingQuietly((FeatureStore)this.getTargetStore());
                    return 0;
                }
                if (groupby.isEndOfGroup(sourceFeature)) {
                    this.status.message("Commiting...");
                    this.getTargetStore().finishEditing();
                    int result = this.commit(null, efectiveDate);
                    if (result != 0) {
                        return result;
                    }
                    this.getTargetStore().edit(1);
                    this.dumpRepositoryConnectionInfo();
                    this.status.message("Copying data...");
                }
                efectiveDate = StringUtils.isBlank((CharSequence)sourceFieldEfectiveDateName) ? null : sourceFeature.getTimestamp(sourceFieldEfectiveDateName);
                boolean needInsert = true;
                Object idvalue = sourceFeature.get(this.getSourceFieldCodeName());
                if (inserteds.contains(idvalue)) {
                    String filter = expBuilder.eq((ExpressionBuilder.Value)expBuilder.column(this.getTargetFieldCodeName()), (ExpressionBuilder.Value)expBuilder.constant(idvalue)).toString();
                    Feature targetFeature = this.getTargetStore().findFirst(filter);
                    if (targetFeature != null) {
                        EditableFeature ef = targetFeature.getEditable();
                        if (this.haveToDelete(sourceFeature)) {
                            this.getTargetStore().delete((Feature)ef);
                        } else {
                            ef.copyFrom(sourceFeature, null, args -> this.addError(idvalue, groupby, 5, "Can't copy values", (String)args[0], (Throwable)args[1]));
                            ef.setUpdatable(true);
                            this.getTargetStore().update(ef);
                        }
                    } else {
                        this.addError(idvalue, groupby, 2, "Try to modify but it has already been deleted.");
                    }
                    needInsert = false;
                }
                if (needInsert) {
                    if (this.haveToDelete(sourceFeature)) {
                        this.addError(idvalue, groupby, 1, "You try to delete something that has already been deleted or has never been inserted.");
                    } else {
                        EditableFeature editableTargetFeature = this.getTargetStore().createNewFeature();
                        editableTargetFeature.copyFrom(sourceFeature, null, args -> this.addError(idvalue, groupby, 5, "Can't copy values", (String)args[0], (Throwable)args[1]));
                        this.getTargetStore().insert(editableTargetFeature);
                        inserteds.add(idvalue);
                    }
                }
                if (this.getTargetStore().getPendingChangesCount() > 1000L) {
                    this.getTargetStore().finishEditing();
                    this.getTargetStore().edit(1);
                }
                groupby.next(sourceFeature);
                this.status.incrementCurrentValue();
            }
            this.status.message("Commiting...");
            this.getTargetStore().finishEditing();
            VCSGisSwingLocator.getVCSGisSwingManager().getDefaultServices().refreshDocument(this.getTargetStore());
            int result = this.commit(null, efectiveDate);
            if (result != 0) {
                return result;
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Can't import history", th);
            return 25;
        }
        return 0;
    }

    protected int process_minimize_memory2(FeatureSet sourceFeatures, GroupBy groupby, boolean requireEfectiveDate, String sourceFieldEfectiveDateName) throws Exception {
        ExpressionBuilder expBuilder = ExpressionUtils.createExpressionBuilder();
        Timestamp efectiveDate = null;
        this.getTargetStore().edit(1);
        this.status.message("Copying data...");
        for (Feature sourceFeature : sourceFeatures) {
            this.update_estimated_time();
            if (this.status.isCancellationRequested()) {
                this.status.cancel();
                FeatureStore.cancelEditingQuietly((FeatureStore)this.getTargetStore());
                return 0;
            }
            if (groupby.isEndOfGroup(sourceFeature)) {
                this.status.message("Commiting...");
                this.getTargetStore().finishEditing();
                if (efectiveDate == null && requireEfectiveDate) {
                    LOGGER.warn("EfectiveDaye (" + sourceFieldEfectiveDateName + ") is null, can't commit.");
                    return 25;
                }
                int result = this.commit(null, efectiveDate);
                if (result != 0) {
                    return result;
                }
                this.dumpRepositoryConnectionInfo();
                this.getTargetStore().edit(1);
                this.status.message("Copying data...");
            }
            efectiveDate = StringUtils.isBlank((CharSequence)sourceFieldEfectiveDateName) ? null : sourceFeature.getTimestamp(sourceFieldEfectiveDateName);
            Object idvalue = sourceFeature.get(this.getSourceFieldCodeName());
            String filter = expBuilder.eq((ExpressionBuilder.Value)expBuilder.column(this.getTargetFieldCodeName()), (ExpressionBuilder.Value)expBuilder.constant(idvalue)).toString();
            Feature targetFeature = this.getTargetStore().findFirst(filter);
            if (targetFeature == null) {
                if (this.haveToDelete(sourceFeature)) {
                    this.addError(idvalue, groupby, 3, "Try to insert and it has already been deleted.");
                } else {
                    EditableFeature editableTargetFeature = this.getTargetStore().createNewFeature(sourceFeature);
                    this.getTargetStore().insert(editableTargetFeature);
                }
            } else {
                EditableFeature ef = targetFeature.getEditable();
                if (this.haveToDelete(sourceFeature)) {
                    this.getTargetStore().delete((Feature)ef);
                } else {
                    ef.copyFrom(sourceFeature);
                    ef.setUpdatable(true);
                    this.getTargetStore().update(ef);
                }
            }
            if (this.getTargetStore().getPendingChangesCount() > 1000L) {
                this.getTargetStore().finishEditing();
                this.getTargetStore().edit(1);
            }
            groupby.next(sourceFeature);
            this.status.incrementCurrentValue();
        }
        this.status.message("Commiting...");
        this.getTargetStore().finishEditing();
        VCSGisSwingLocator.getVCSGisSwingManager().getDefaultServices().refreshDocument(this.getTargetStore());
        if (efectiveDate == null && requireEfectiveDate) {
            LOGGER.warn("EfectiveDaye (" + sourceFieldEfectiveDateName + ") is null, can't commit.");
            return 25;
        }
        int result = this.commit(null, efectiveDate);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    protected boolean hasDuplicatedDeletes() {
        return this.hasDuplicatedDeletes;
    }

    protected boolean hasErrors() {
        return this.hasErrors;
    }

    protected int addError(Object id, GroupBy groupby, int code, String description) {
        return this.addError(id, groupby, code, description, null, null);
    }

    protected int addError(Object id, GroupBy groupby, int code, String description, String errmsg, Throwable th) {
        this.hasErrors = true;
        if (code == 0 || code == 1) {
            this.hasDuplicatedDeletes = true;
        }
        if (StringUtils.isBlank((CharSequence)errmsg)) {
            errmsg = "-";
        }
        if (th == null) {
            LOGGER.warn("Feature " + groupby.getGroupLabel() + "/" + id + ". " + description);
            this.log(code + ";" + Objects.toString(id) + ";" + groupby.getGroupLabel() + ";" + description + ";" + errmsg);
        } else {
            LOGGER.warn("Feature " + groupby.getGroupLabel() + "/" + id + ". " + description, th);
        }
        this.log(code + ";" + Objects.toString(id) + ";" + groupby.getGroupLabel() + ";" + description + ";" + errmsg);
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String line) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.getLogFile(), true);
            writer.append(line);
            writer.append("\n");
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't add information to log file '" + this.getLogFile().getAbsolutePath() + "'.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    @Override
    public File getLogFile() {
        if (this.logFile == null) {
            this.logFile = ToolsLocator.getFoldersManager().getUniqueTemporaryFile(new String[]{"import-history-" + this.getTargetStore().getName() + ".log"});
        }
        return this.logFile;
    }

    protected static interface GroupBy {
        public boolean isEndOfGroup(Feature var1);

        public void next(Feature var1);

        public String getGroupLabel();
    }
}

