/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.managehistory;

import java.awt.Cursor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.FolderPickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.swing.VCSGisJRestoreHistory;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingManagerImpl;
import org.gvsig.vcsgis.swing.impl.managehistory.RestoreHistory;
import org.gvsig.vcsgis.swing.impl.managehistory.VCSGisJRestoreHistoryView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJRestoreHistoryImpl
extends VCSGisJRestoreHistoryView
implements Component,
VCSGisJRestoreHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJRestoreHistoryImpl.class);
    private Dialog dialog;
    private boolean processing = false;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private TaskStatusController taskStatusController;
    private FolderPickerController folderController;

    public VCSGisJRestoreHistoryImpl() {
        this.initComponents();
    }

    private void initComponents() {
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.translate();
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.lblStatusTitle, this.lblStatusMessages, this.pbStatus);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspaces, this.btnInitWorkspace);
        this.workspacePicker.addChangeListener(e -> {
            this.doChangeWorkspace();
            this.doUpdateComponents();
        });
        this.folderController = ToolsSwingLocator.getToolsSwingManager().createFolderPickerController((JTextComponent)this.txtFolder, this.btnFolder);
        this.folderController.addChangeListener(e -> this.doChangeFolder());
        this.lstEntities.addListSelectionListener(e -> this.doUpdateComponents());
        this.showMessage(" ", null);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)22, (int)60);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusTitle.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeWorkspace() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        Cursor savedCursor = this.getCursor();
        try {
            this.processing = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            VCSGisWorkspace ws = this.getWorkspace();
            if (!this.isValidWorkspace(ws)) {
                this.showMessage(i18n.getTranslation("_Working_copy_not_valid"), i18n.getTranslation("_The_repository_of_the_selected_working_copy_is_not_accessible_by_this_tool"));
            }
            this.doUpdateComponents();
        }
        catch (VCSGisRuntimeException e1) {
            LOGGER.warn("Can't set workspace.", (Throwable)e1);
            if (VCSGisSwingCommons.showAuthenticationErrors("_VCS_Restore_history", e1)) {
                this.workspacePicker.set(null);
                this.doChangeWorkspace();
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Can't set workspace.", (Throwable)e2);
        }
        finally {
            this.processing = false;
            this.setCursor(savedCursor);
        }
    }

    public VCSGisWorkspace getWorkspace() {
        return (VCSGisWorkspace)this.workspacePicker.get();
    }

    private void doUpdateComponents() {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(this::doUpdateComponents)) {
            return;
        }
        VCSGisWorkspace workspace = this.getWorkspace();
        boolean isProcessing = this.processing;
        boolean canRestore = !isProcessing && workspace != null && this.isValidWorkspace(workspace) && this.folderController.get() != null && !this.lstEntities.getSelectedValuesList().isEmpty();
        this.workspacePicker.setEnabled(!isProcessing);
        this.folderController.setEnabled(!isProcessing);
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, canRestore);
        }
    }

    private void showMessage(String message, String toolTipText) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.showMessage(message, toolTipText))) {
            return;
        }
        this.lblStatusMessages.setText(message);
        this.lblStatusMessages.setToolTipText(toolTipText);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
        swingManager.translate(this.lblEntitiesFile);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public static void selfRegister() {
        String[][] iconsInfo = new String[][]{{"VCSGis", "vcsgis", "vcsgis-restore-history"}};
        VCSGisSwingManagerImpl.registerIcons(iconsInfo);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return VCSGisSwingManagerImpl.loadImage(imageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int restoreHistory() {
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace == null) {
            return 0;
        }
        if (!(workspace.getRepository() instanceof VCSGisRepositoryLocaldb)) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog("Only local repositories allowed", "_VCS_Restore_history", 2);
            return 0;
        }
        VCSGisRepositoryLocaldb repository = (VCSGisRepositoryLocaldb)workspace.getRepository();
        this.setVisibleStatus(true);
        List files = this.lstEntities.getSelectedValuesList();
        if (files.isEmpty()) {
            return 0;
        }
        for (LabeledValue entitiesFile : files) {
            String entityName;
            Pair<String, String> e1;
            String entityCode;
            if (entitiesFile == null || !this.existsEntity(workspace, entityCode = (String)(e1 = this.getEntityFromSourceFile((File)entitiesFile.getValue())).getLeft(), entityName = (String)e1.getRight())) continue;
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisWorkspaceEntity lentity = workspace.getWorkspaceEntityByName(entityName);
            int n = dialogs.confirmDialog("The entity '" + entityName + "' already exists in repository.\n" + "\n" + "Entities file: " + ((File)entitiesFile.getValue()).getAbsolutePath() + "\n" + "Entity: " + entityName + " (code '" + entityCode + "').\n" + "Repository: " + repository.getServerExplorer().getParameters().getUrl() + "\n" + "\n" + "This action can not be undone. It is recommended that you back up your data before proceeding.\n" + "Do you want to remove entity '" + entityName + "' from the repository and continue with the data import?", "_VCS_Restore_history", 0, 3);
            if (n != 0) {
                return 200;
            }
            if (!lentity.getEntityCode().equalsIgnoreCase(entityCode) && (n = dialogs.confirmDialog("The entity code of '" + entityName + "' in the copy you are restoring does not match that of the existing entity.\n" + "If you continue existing local copies will not be valid.\n" + "Do you want to continue anyway ?", "_VCS_Restore_history", 0, 3)) != 0) {
                return 200;
            }
            if (this.deleteRepositoryEntity(workspace, entityCode, entityName)) continue;
            dialogs.messageDialog("Can't delete entity '" + entityName + "' (code '" + entityCode + "') from repository.", "_VCS_Restore_history", 2);
            return 200;
        }
        boolean checkOnly = this.chkCheckOnly.isSelected();
        try {
            this.processing = true;
            this.doUpdateComponents();
            for (LabeledValue entitiesFile : files) {
                int n;
                if (entitiesFile == null || (n = this.restoreHistory(workspace, (File)entitiesFile.getValue(), checkOnly)) == 0) continue;
                int n2 = n;
                return n2;
            }
        }
        finally {
            this.processing = false;
            this.doUpdateComponents();
        }
        return 0;
    }

    private int restoreHistory(VCSGisWorkspace workspace, File entitiesFile, boolean checkOnly) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.setVisibleStatus(true);
        if (workspace != null && entitiesFile != null && entitiesFile.exists()) {
            SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Restore history");
            try {
                taskStatus.setAutoremove(true);
                taskStatus.add();
                taskStatus.setRangeOfValues(0L, 1L);
                taskStatus.setCurValue(0L);
                this.taskStatusController.bind((TaskStatus)taskStatus);
                VCSGisRepository repository = workspace.getRepository();
                JDBCServerExplorerParameters serverExplorerParameters = null;
                if (repository instanceof VCSGisRepositoryLocaldb) {
                    serverExplorerParameters = ((VCSGisRepositoryLocaldb)repository).getServerExplorer().getParameters();
                }
                taskStatus.setTitle("Restore history - " + entitiesFile.getName() + taskStatus.getProgressLabel());
                this.showMessage(i18n.getTranslation("_Processing"), null);
                RestoreHistory restoreHistory = new RestoreHistory(serverExplorerParameters, entitiesFile, taskStatus);
                restoreHistory.setCheckOnly(checkOnly);
                int res = restoreHistory.call();
                if (res != 0) {
                    this.showMessage(i18n.getTranslation("_Aborting_process"), null);
                    taskStatus.abort();
                    return res;
                }
                taskStatus.incrementCurrentValue();
                this.showMessage(i18n.getTranslation("_Ended_process"), null);
                taskStatus.terminate();
                return res;
            }
            catch (UserCancelledException ex) {
                LOGGER.warn("User cancelled");
                taskStatus.cancel();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't restore history", (Throwable)ex);
                taskStatus.abort();
            }
        }
        return 600;
    }

    private boolean isValidWorkspace(VCSGisWorkspace ws) {
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace != null) {
            VCSGisRepository repository = workspace.getRepository();
            return repository instanceof VCSGisRepositoryLocaldb;
        }
        return false;
    }

    private void doChangeFolder() {
        File folder = (File)this.folderController.get();
        if (folder == null) {
            this.lstEntities.setModel(new DefaultListModel());
            this.doUpdateComponents();
            return;
        }
        DefaultListModel<LabeledValueImpl> model = new DefaultListModel<LabeledValueImpl>();
        Collection files0 = FileUtils.listFiles((File)folder, (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".csv", (IOCase)IOCase.INSENSITIVE), (IOFileFilter)FileFilterUtils.falseFileFilter());
        ArrayList files = new ArrayList(files0);
        files.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (File file : files) {
            String fname = FilenameUtils.getBaseName((String)file.getName());
            if (!StringUtils.startsWithIgnoreCase((CharSequence)fname, (CharSequence)"ENTITIES_")) continue;
            String entityName = StringUtils.removeStart((String)fname, (String)"ENTITIES_");
            model.addElement(new LabeledValueImpl(entityName, (Object)file));
        }
        this.lstEntities.setModel(model);
        this.doUpdateComponents();
    }

    private boolean existsEntity(VCSGisWorkspace ws, String entityCode, String entityName) {
        try {
            if (ws.getRepositoryEntityByName(entityName) != null) {
                return true;
            }
            return ws.getRepositoryEntityByCode(entityCode) != null;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check entity'" + entityCode + "/" + entityName + "'.", (Throwable)ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<String, String> getEntityFromSourceFile(File sourceEntityFile) {
        if (sourceEntityFile == null) {
            LOGGER.warn("Can't get entity from file, file is null.");
            return null;
        }
        DataManager dataManager = DALLocator.getDataManager();
        FeatureStore sourceEntitiesStore = null;
        try {
            sourceEntitiesStore = (FeatureStore)dataManager.openStore("CSV", new Object[]{"file=", sourceEntityFile, "automaticTypesDetection=", false, "locale=", "en"});
            Feature firstFeature = sourceEntitiesStore.first();
            if (firstFeature == null) {
                LOGGER.warn("Can't get entity from file '" + sourceEntityFile.getAbsolutePath() + "', first feature is null.");
                Pair<String, String> pair = null;
                DisposeUtils.disposeQuietly((Disposable)sourceEntitiesStore);
                return pair;
            }
            String entityName = firstFeature.getString("ENT_NAME");
            String entityCode = firstFeature.getString("COD_ENTITY");
            if (StringUtils.isBlank((CharSequence)entityName)) {
                LOGGER.warn("Can't get entity from file '" + sourceEntityFile.getAbsolutePath() + "', enity name is blank.");
                Pair<String, String> pair = null;
                DisposeUtils.disposeQuietly((Disposable)sourceEntitiesStore);
                return pair;
            }
            if (StringUtils.isBlank((CharSequence)entityCode)) {
                LOGGER.warn("Can't get entity from file '" + sourceEntityFile.getAbsolutePath() + "', enity code is blank.");
                Pair<String, String> pair = null;
                DisposeUtils.disposeQuietly((Disposable)sourceEntitiesStore);
                return pair;
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)entityCode, (Object)entityName);
            DisposeUtils.disposeQuietly((Disposable)sourceEntitiesStore);
            return immutablePair;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get entity from file '" + sourceEntityFile.getAbsolutePath() + "'.", (Throwable)ex);
            Pair<String, String> pair = null;
            return pair;
        }
        finally {
            DisposeUtils.disposeQuietly(sourceEntitiesStore);
        }
    }

    private boolean deleteRepositoryEntity(VCSGisWorkspace ws, String entityCode, String entityName) {
        VCSGisRepositoryLocaldb repo = (VCSGisRepositoryLocaldb)ws.getRepository();
        LOGGER.info("Deleting entity '" + entityName + " code '" + entityCode + "' from repository '" + repo.getServerExplorer().getParameters().getUrl() + "'.");
        this.showMessage("Deleting entity '" + entityName + "'...", null);
        return repo.deleteEntity(entityName);
    }
}

