/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.showServerTableForm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.gvsig.featureform.swing.CreateJFeatureFormException;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.swing.VCSGisJShowServerTableForm;
import org.gvsig.vcsgis.swing.impl.showServerTableForm.VCSGisJShowServerTableFormView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJShowServerTableFormImpl
extends VCSGisJShowServerTableFormView
implements VCSGisJShowServerTableForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJShowServerTableFormImpl.class);
    private PickerController<JDBCServerExplorerParameters> connectionPicker;
    private JDBCServerExplorerParameters connection;
    private final String tableName;
    JFeaturesForm form;

    public VCSGisJShowServerTableFormImpl(String tableName) {
        this.tableName = tableName;
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        this.connectionPicker = DALSwingLocator.getSwingManager().createJDBCConnectionPickerController(this.cboConnections, this.btnAddConnection);
        this.connectionPicker.addChangeListener(e -> {
            this.connection = null;
            this.doChangeConnection();
        });
        this.setPreferredSize(new Dimension(520, 360));
        this.pnlForm.setLayout(new BorderLayout());
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeConnection() {
        VCSGisRepository repo;
        JDBCServerExplorer server;
        block8: {
            DataManager dataManager;
            block7: {
                dataManager = DALLocator.getDataManager();
                VCSGisManager vcsManager = VCSGisLocator.getManager();
                server = null;
                repo = null;
                repo = vcsManager.openRepository(this.getConnection());
                if (repo != null) break block7;
                this.pnlForm.setVisible(false);
                I18nManager i18n = ToolsLocator.getI18nManager();
                JOptionPane.showMessageDialog(null, i18n.getTranslation("_The_selected_connection_does_not_correspond_to_a_version_control_server"));
                DisposeUtils.disposeQuietly((Disposable)repo);
                DisposeUtils.disposeQuietly((Disposable)server);
                return;
            }
            try {
                FeatureStore store;
                server = this.getServer();
                JDBCStoreParameters params = server.get(this.tableName);
                if (params == null || (store = (FeatureStore)dataManager.openStore(params.getProviderName(), (DataStoreParameters)params)) == null) break block8;
                if (this.form == null) {
                    this.form = this.createform(store);
                    this.pnlForm.add((Component)this.form.asJComponent(), "Center");
                    this.revalidate();
                } else {
                    this.form.bind(store);
                }
                this.pnlForm.setVisible(true);
            }
            catch (Exception ex) {
                try {
                    this.pnlForm.setVisible(false);
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(null, i18n.getTranslation("_The_selected_connection_does_not_correspond_to_a_version_control_server"));
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(repo);
                    DisposeUtils.disposeQuietly(server);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)repo);
                DisposeUtils.disposeQuietly((Disposable)server);
            }
        }
        DisposeUtils.disposeQuietly((Disposable)repo);
        DisposeUtils.disposeQuietly((Disposable)server);
    }

    private JFeaturesForm createform(FeatureStore featureStore) throws CreateJFeatureFormException, ServiceException, DataException {
        DataSwingManager swingManager = DALSwingLocator.getSwingManager();
        JFeaturesForm form = swingManager.createJFeaturesForm(featureStore);
        form.getFormset().setAllowDelete(true);
        form.getFormset().setAllowNew(true);
        ToolsSwingLocator.getToolsSwingManager().removeBorder(form.asJComponent());
        return form;
    }

    public JDBCServerExplorerParameters getConnection() {
        if (this.connection == null) {
            this.connection = (JDBCServerExplorerParameters)this.connectionPicker.get();
        }
        return this.connection;
    }

    public JDBCServerExplorer getServer() {
        JDBCServerExplorer server = null;
        try {
            DataManager dataManager = DALLocator.getDataManager();
            if (this.getConnection() != null) {
                server = (JDBCServerExplorer)dataManager.openServerExplorer(this.getConnection().getExplorerName(), (DataServerExplorerParameters)this.getConnection());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't open server " + this.getConnection().getExplorerName());
        }
        return server;
    }
}

