/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi.simpleprovider;

import java.io.File;
import java.util.Objects;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderFactory;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderStoreParameters;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;

public class SimpleSequentialReaderFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    private FilesystemServerExplorerProviderServices serverExplorer;
    private final SimpleSequentialReaderFactory readerFactory;

    public SimpleSequentialReaderFilesystemServerProvider(SimpleSequentialReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
    }

    @Override
    public String getDataStoreProviderName() {
        try {
            return this.readerFactory.getName();
        }
        catch (Throwable th) {
            LOGGER.warn("Can't get the provider name, return the class simplename.", th);
            return this.getClass().getSimpleName();
        }
    }

    @Override
    public int getMode() {
        return 3;
    }

    @Override
    public boolean accept(File file) {
        try {
            return this.readerFactory.accept(file);
        }
        catch (Throwable th) {
            try {
                LOGGER.warn("Can't check if the provider accept file '" + Objects.toString(file) + "', check file extension only.", th);
                return this.readerFactory.isValidExtension(file);
            }
            catch (Throwable th2) {
                LOGGER.warn("Can't check if the provider accept file '" + Objects.toString(file) + "', return false.", th2);
                return false;
            }
        }
    }

    @Override
    public DataStoreParameters getParameters(File file) throws DataException {
        SimpleSequentialReaderStoreParameters params = new SimpleSequentialReaderStoreParameters(this.readerFactory);
        params.setFile(file);
        return params;
    }

    @Override
    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    @Override
    public String getDescription() {
        try {
            return this.readerFactory.getDescription();
        }
        catch (Throwable th) {
            LOGGER.warn("Can't get the provider description, return the class name.", th);
            return this.getClass().getName();
        }
    }
}

