/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi.simpleprovider;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderFactory;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderStoreProviderFactory;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSequentialReaderStoreParameters
extends AbstractDataStoreParameters
implements OpenFeatureStoreParameters,
FilesystemStoreParameters,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSequentialReaderStoreParameters.class);
    private static final String FILE = "file";
    private static final String IGNOREERRORS = "ignoreErrors";
    private static final String CRS = "CRS";
    private static final String FIELDTYPES = "fieldtypes";
    private static final String FIELDNAMES = "fieldnames";
    private static final String LOCALE = "locale";
    private static final String POINT = "pointFields";
    private static final String AUTOMATICTYPESDETECTION = "automaticTypesDetection";
    private DelegatedDynObject parameters;
    private SimpleSequentialReaderFactory readerFactory;

    public SimpleSequentialReaderStoreParameters() {
    }

    public SimpleSequentialReaderStoreParameters(SimpleSequentialReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
        this.parameters = (DelegatedDynObject)FileHelper.newParameters(readerFactory.getName());
        this.setDynValue("ProviderName", readerFactory.getName());
    }

    protected Object clone() throws CloneNotSupportedException {
        SimpleSequentialReaderStoreParameters other = (SimpleSequentialReaderStoreParameters)super.clone();
        other.parameters = (DelegatedDynObject)FileHelper.newParameters(this.readerFactory.getName());
        this.copyValuesTo((DataParameters)other);
        return other;
    }

    public String getDataStoreName() {
        return (String)this.getDynValue("ProviderName");
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        String providerName = (String)state.get("ProviderName");
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        SimpleSequentialReaderStoreProviderFactory provider = (SimpleSequentialReaderStoreProviderFactory)dataman.getStoreProviderFactory(providerName);
        this.readerFactory = provider.getReaderFactory();
        this.parameters = (DelegatedDynObject)FileHelper.newParameters(this.readerFactory.getName());
        super.loadFromState(state);
    }

    public String getDescription() {
        return this.getDynClass().getDescription();
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }

    public void setDynValue(String name, Object value) {
        super.setDynValue(name, value);
        if (this.readerFactory != null && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)FILE)) {
            this.readerFactory.fetchDefaultParameters((DataParameters)this);
        }
    }

    public boolean isValid() {
        return this.getPathName() != null;
    }

    @Override
    public File getFile() {
        return (File)this.getDynValue(FILE);
    }

    @Override
    public void setFile(File file) {
        this.setDynValue(FILE, file);
    }

    public IProjection getCRS() {
        return (IProjection)this.parameters.getDynValue(CRS);
    }

    public String getPathName() {
        File f = (File)this.parameters.getDynValue(FILE);
        if (f == null) {
            return null;
        }
        return f.getPath();
    }

    public Locale getLocale() {
        try {
            Locale locale;
            String s = (String)this.parameters.getDynValue(LOCALE);
            if (s.trim().length() == 0) {
                return null;
            }
            if ("DEFAULT".equalsIgnoreCase(s.trim())) {
                return Locale.getDefault();
            }
            String[] ss = s.split("-");
            switch (ss.length) {
                case 1: {
                    locale = new Locale(ss[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(ss[0], ss[1]);
                    break;
                }
                default: {
                    locale = new Locale(ss[0], ss[1], ss[2]);
                }
            }
            return locale;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get locale from ODS parameters.", (Throwable)ex);
            return null;
        }
    }

    public String[] getPointDimensionNames() {
        String s = (String)this.parameters.getDynValue(POINT);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        String sep = this.getDelimiter(s);
        if (sep == null) {
            return new String[]{s};
        }
        return s.split(sep);
    }

    public boolean getIgnoreErrors() {
        Boolean b = (Boolean)this.parameters.getDynValue(IGNOREERRORS);
        if (b == null) {
            return false;
        }
        return b;
    }

    private String getDelimiter(String line) {
        String sep = null;
        String seps = ",;-|@#/+$%&!:";
        for (int i = 0; i < seps.length(); ++i) {
            sep = seps.substring(i, 1);
            if (line.contains(seps.substring(i, 1))) break;
            sep = null;
        }
        return sep;
    }

    public List<String> getFieldNames() {
        String s = (String)this.parameters.getDynValue(FIELDNAMES);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        String sep = this.getDelimiter(s);
        if (sep == null) {
            return null;
        }
        String[] fieldNames = s.split("[" + sep + "]");
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = fieldNames[i].trim();
        }
        return Arrays.asList(fieldNames);
    }

    public int[] getFieldTypes() {
        String s = (String)this.parameters.getDynValue(FIELDTYPES);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        String sep = this.getDelimiter(s);
        if (sep == null) {
            return null;
        }
        DataTypesManager dataTypeManager = ToolsLocator.getDataTypesManager();
        String[] fieldTypeNames = s.split("[" + sep + "]");
        int[] fieldTypes = new int[fieldTypeNames.length];
        for (int i = 0; i < fieldTypeNames.length; ++i) {
            s = fieldTypeNames[i].trim();
            if (s.contains(":")) {
                s = s.split(":")[0];
            }
            fieldTypes[i] = dataTypeManager.getType(s);
        }
        return fieldTypes;
    }

    public int[] getFieldSizes() {
        String s = (String)this.parameters.getDynValue(FIELDTYPES);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        String sep = this.getDelimiter(s);
        if (sep == null) {
            return null;
        }
        String[] fieldTypeNames = s.split("[" + sep + "]");
        int[] fieldSizes = new int[fieldTypeNames.length];
        for (int i = 0; i < fieldTypeNames.length; ++i) {
            String fieldtype = fieldTypeNames[i].trim();
            if (fieldtype.contains(":")) {
                try {
                    s = fieldtype.split(":")[1];
                    fieldSizes[i] = Integer.parseInt(s);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't get size of field " + i + " (" + fieldtype + ").", (Throwable)ex);
                }
                continue;
            }
            fieldSizes[i] = 0;
        }
        return fieldSizes;
    }

    public boolean getAutomaticTypesDetection() {
        Boolean b = (Boolean)this.parameters.getDynValue(AUTOMATICTYPESDETECTION);
        if (b == null) {
            return false;
        }
        return b;
    }

    public String getSourceId() {
        return this.toString();
    }

    public boolean isTheSameExplorer(DataStoreParameters parameters) {
        return FilesystemStoreParameters.isTheSameExplorer((DataStoreParameters)this, parameters);
    }
}

