/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.filesystem.impl;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderFactory;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFilesystemServerExplorerProvider.class);
    private String name;
    private String description;
    private FilesystemServerExplorerProviderFactory factory;

    protected AbstractFilesystemServerExplorerProvider() {
    }

    protected AbstractFilesystemServerExplorerProvider(FilesystemServerExplorerProviderFactory factory, String name, String description) {
        this.factory = factory;
        this.name = name;
        this.description = description;
    }

    protected AbstractFilesystemServerExplorerProvider(String name, String description) {
        this(null, name, description);
    }

    public FilesystemServerExplorerProviderFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getDataStoreProviderName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getResourceRootPathName(DataStore dataStore) {
        return this.getResourceRootPathName(dataStore.getParameters());
    }

    @Override
    public String getResourceRootPathName(DataStoreParameters parameters) {
        Object obj;
        File f;
        if (parameters instanceof FilesystemStoreParameters && (f = ((FilesystemStoreParameters)parameters).getFile()) != null) {
            return FilenameUtils.removeExtension((String)f.getAbsolutePath());
        }
        if (parameters.hasDynValue("file") && (obj = parameters.getDynValue("file")) != null) {
            return this.removeFileExtension(new File(obj.toString()));
        }
        return null;
    }

    protected String removeFileExtension(File file) {
        int whereDot = file.getName().lastIndexOf(".");
        if (0 < whereDot && whereDot <= file.getName().length() - 2) {
            whereDot = file.getAbsolutePath().lastIndexOf(".");
            return file.getAbsolutePath().substring(0, whereDot);
        }
        return file.getAbsolutePath();
    }

    @Override
    public int getMode() {
        return 0;
    }

    @Override
    public boolean isMode(int mode) {
        if (mode == 0) {
            return true;
        }
        return (this.getMode() & mode) != 0;
    }

    public DataStoreParameters getParameters(File file) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        DataStoreParameters params = manager.createStoreParameters(this.getDataStoreProviderName());
        ((FilesystemStoreParameters)params).setFile(file);
        return params;
    }

    @Override
    public boolean canCreate() {
        return false;
    }

    @Override
    public boolean canCreate(NewDataStoreParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NewDataStoreParameters getCreateParameters() throws DataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(DataStoreParameters parameters) throws RemoveException {
        File file = ((FilesystemStoreParameters)parameters).getFile();
        if (!file.exists()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new FileNotFoundException(file));
        }
        if (!file.delete()) {
            // empty if block
        }
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return false;
    }

    public void resourceChanged(ResourceProvider resource) {
    }

    @Override
    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
    }
}

