/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeatureProviderLoadedOnDemand
extends DefaultFeatureProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFeatureProviderLoadedOnDemand.class);
    protected boolean loading = false;
    protected boolean loaded = false;
    protected String geomName;

    public AbstractFeatureProviderLoadedOnDemand(FeatureType type) {
        super(type);
        FeatureAttributeDescriptor geomdesc = type.getDefaultGeometryAttribute();
        if (geomdesc != null) {
            this.geomName = geomdesc.getName();
        }
    }

    protected void load() {
        if (this.loading || this.loaded || this.isNew()) {
            return;
        }
        this.loading = true;
        try {
            this.doLoad();
        }
        catch (Exception e) {
            this.warn("Can't load feature", e);
        }
        finally {
            this.loading = false;
            this.loaded = true;
        }
    }

    protected abstract void doLoad();

    public void set(int i, Object value) {
        this.load();
        super.set(i, value);
    }

    public void set(String name, Object value) {
        this.load();
        super.set(this.featureType.getIndex(name), value);
    }

    public Object get(int i) {
        this.load();
        return super.get(i);
    }

    public Object get(String name) {
        this.load();
        return super.get(name);
    }

    public Geometry getDefaultGeometry() {
        if (this.geomName == null) {
            return null;
        }
        return (Geometry)this.get(this.geomName);
    }

    public Envelope getDefaultEnvelope() {
        Geometry geom = this.getDefaultGeometry();
        if (geom == null) {
            return null;
        }
        try {
            return geom.getEnvelope();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setOID(Object oid) {
        this.loaded = false;
        super.setOID(oid);
    }

    public FeatureProvider getCopy() {
        this.load();
        return super.getCopy();
    }

    protected void warn(String message, Throwable t) {
    }
}

