/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.store.simplereader.AutomaticDetectionOfTypes;
import org.gvsig.fmap.dal.store.simplereader.FieldTypeParser;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderUtils;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.SimpleReader;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleReaderFeatureTypeLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleReaderFeatureTypeLoader.class);
    protected boolean all_fields_declare_type;
    protected SimpleReaderStoreParameters parameters;

    public SimpleReaderFeatureTypeLoader(SimpleReaderStoreParameters parameters) {
        this.parameters = parameters;
    }

    protected SimpleReaderFeatureTypeLoader() {
        this.parameters = null;
    }

    protected abstract String getProviderName();

    protected abstract SimpleReader getSimpleReader(Reader var1) throws IOException;

    protected FieldTypeParser[] getFieldTypes(String[] headers, AutomaticDetectionOfTypes.DetectedValue[] automaticTypes) {
        String sep;
        int i;
        String fullFileName = this.parameters.getFile() == null ? "" : this.parameters.getFile().getAbsolutePath();
        FieldTypeParser[] fieldTypes = new FieldTypeParser[headers.length];
        for (i = 0; i < fieldTypes.length; ++i) {
            fieldTypes[i] = new FieldTypeParser(this.getProviderName(), fullFileName);
        }
        if (automaticTypes != null) {
            for (i = 0; i < fieldTypes.length && i < automaticTypes.length; ++i) {
                fieldTypes[i].detectedValue = automaticTypes[i];
                fieldTypes[i].type = automaticTypes[i].getType();
            }
        }
        this.all_fields_declare_type = true;
        for (i = 0; i < fieldTypes.length; ++i) {
            if (!fieldTypes[i].parse(headers[i])) {
                LOGGER.warn("Can't parse header of field " + i + "( " + headers[i] + ") in '" + this.getProviderName() + "' file '" + fullFileName + "'.");
            }
            if (fieldTypes[i].type != 0) continue;
            this.all_fields_declare_type = false;
            fieldTypes[i].type = 8;
        }
        String param_types_def = SimpleReaderStoreParameters.getRawFieldTypes((DynObject)this.parameters);
        if (StringUtils.isNotBlank((CharSequence)param_types_def) && StringUtils.isNotBlank((CharSequence)(sep = SimpleReaderStoreParameters.getDelimiter(param_types_def)))) {
            String[] param_types = param_types_def.split(sep);
            FieldTypeParser parser = new FieldTypeParser(this.getProviderName(), fullFileName);
            block3: for (String param_type : param_types) {
                parser.clear();
                parser.parse(param_type);
                for (FieldTypeParser fieldType : fieldTypes) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)fieldType.name, (CharSequence)parser.name)) continue;
                    fieldType.copyFrom(parser);
                    continue block3;
                }
            }
        }
        return fieldTypes;
    }

    protected void fillFeatureType(EditableFeatureType fType, FieldTypeParser[] fieldTypes) {
        EditableFeatureAttributeDescriptor fad;
        String fullFileName = this.parameters.getFile() == null ? "" : this.parameters.getFile().getAbsolutePath();
        Tags ftypeTags = fType.getTags();
        for (FieldTypeParser fieldType : fieldTypes) {
            fad = fType.add(fieldType.name, fieldType.type);
            if (fieldType.detectedValue != null) {
                fad.setDisplaySize(Math.max(fieldType.detectedValue.getDisplaySize(), fieldType.size));
                fad.setSize(Math.max(fieldType.detectedValue.getDisplaySize(), fieldType.size));
                if (fad.getPrecision() < fieldType.detectedValue.getPrecision()) {
                    fad.setPrecision(fieldType.detectedValue.getPrecision());
                }
                if (fad.getScale() < fieldType.detectedValue.getScale()) {
                    fad.setScale(fieldType.detectedValue.getScale());
                }
            } else {
                fad.setDisplaySize(fieldType.size);
            }
            if (fieldType.type == 66) {
                fad.setGeometryType(fieldType.geomType, fieldType.geomSubtype);
                if (fType.getDefaultGeometryAttributeName() == null) {
                    fType.setDefaultGeometryAttributeName(fieldType.name);
                }
            }
            Locale locale = null;
            if (fieldType.type == 11) {
                if (!SimpleReaderStoreParameters.isBlankOrDefaultLocale((DynObject)this.parameters)) {
                    locale = SimpleReaderStoreParameters.getLocale((DynObject)this.parameters);
                }
            } else {
                locale = SimpleReaderStoreParameters.getLocale((DynObject)this.parameters);
            }
            fad.setLocale(locale);
            for (Map.Entry<String, String> entry : fieldType.assignments.entrySet()) {
                try {
                    switch (entry.getKey().toLowerCase()) {
                        case "expression": {
                            break;
                        }
                        default: {
                            fad.set(entry.getKey(), (Object)entry.getValue());
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't set property '" + entry.getKey() + "' of '" + fad.getName() + "'.", (Throwable)ex);
                }
            }
            Tags tags = fad.getTags();
            for (Map.Entry<String, String> entry3 : fieldType.tags.entrySet()) {
                tags.set(entry3.getKey(), (Object)entry3.getValue());
            }
            for (Map.Entry<String, String> entry : fieldType.typetags.entrySet()) {
                ftypeTags.set(entry.getKey(), (Object)entry.getValue());
            }
            for (Map.Entry<String, String> entry : fieldType.typeAssignments.entrySet()) {
                try {
                    fType.set(entry.getKey(), entry.getValue());
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't set attribute '" + entry.getKey() + "' in the feature type.", (Throwable)ex);
                }
            }
        }
        for (FieldTypeParser fieldType : fieldTypes) {
            fad = fType.getEditableAttributeDescriptor(fieldType.name);
            for (Map.Entry<String, String> entry : fieldType.assignments.entrySet()) {
                try {
                    switch (entry.getKey().toLowerCase()) {
                        case "expression": {
                            fad.set(entry.getKey(), (Object)entry.getValue());
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't set property '" + entry.getKey() + "' in '" + fad.getName() + "' of '" + fullFileName + "'.", (Throwable)exception);
                }
            }
        }
    }

    public boolean loadFeatureType(EditableFeatureType featureType, SimpleTaskStatus status) throws IOException {
        return this.loadFeatureType(featureType, true, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFeatureType(EditableFeatureType featureType, boolean detectTypes, SimpleTaskStatus status) throws IOException {
        boolean bl;
        InputStreamReader in = null;
        SimpleReader reader = null;
        try {
            in = SimpleReaderUtils.openFile(this.parameters.getFile(), SimpleReaderStoreParameters.getCharset((DynObject)this.parameters));
            reader = this.getSimpleReader(in);
            Object[] headers = this.getHeaders(reader);
            Object[] detectedTypes = null;
            if (detectTypes) {
                detectedTypes = this.automaticDetectionOfTypes((String[])headers, status);
            }
            if (StringUtils.isBlank((CharSequence)headers[headers.length - 1]) && (detectedTypes == null || detectedTypes[headers.length - 1].isBlank())) {
                headers = (String[])ArrayUtils.remove((Object[])headers, (int)(headers.length - 1));
                if (detectedTypes != null) {
                    detectedTypes = (AutomaticDetectionOfTypes.DetectedValue[])ArrayUtils.remove((Object[])detectedTypes, (int)(detectedTypes.length - 1));
                }
            }
            if (detectedTypes != null && detectedTypes.length > headers.length) {
                String[] headers2 = new String[detectedTypes.length];
                for (int i = 0; i < headers2.length; ++i) {
                    headers2[i] = i < headers.length ? headers[i] : this.getFixedHeader(i);
                }
                headers = headers2;
            }
            for (int i = 0; i < headers.length; ++i) {
                if (!StringUtils.isBlank((CharSequence)headers[i])) continue;
                headers[i] = this.getFixedHeader(i);
            }
            this.fillFeatureType(featureType, (String[])headers, (AutomaticDetectionOfTypes.DetectedValue[])detectedTypes);
            bl = this.all_fields_declare_type;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Closeable)reader);
        return bl;
    }

    protected String[] getHeaders(SimpleReader reader) throws RuntimeException, IOException {
        String[] headers = SimpleReaderStoreParameters.getHeaders((DynObject)this.parameters);
        return headers;
    }

    protected String[] getFixedHeaders(int count) {
        String[] headers = new String[count];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = this.getFixedHeader(i);
        }
        return headers;
    }

    protected String getFixedHeader(int column) {
        char[] header = new char[3];
        String s = String.format("%03d", column);
        header[0] = (char)(s.charAt(0) + 17);
        header[1] = (char)(s.charAt(1) + 17);
        header[2] = (char)(s.charAt(2) + 17);
        return String.valueOf(header);
    }

    private AutomaticDetectionOfTypes.DetectedValue[] automaticDetectionOfTypes(String[] headers, SimpleTaskStatus status) throws IOException {
        String fullFileName = this.parameters.getFile() == null ? "NULL" : this.parameters.getFile().getAbsolutePath();
        boolean automatic_types_detection = SimpleReaderStoreParameters.getAutomaticTypesDetection((DynObject)this.parameters);
        if (!automatic_types_detection) {
            return null;
        }
        AutomaticDetectionOfTypes.DetectedValue[] types = null;
        InputStreamReader in = null;
        SimpleReader reader = null;
        try {
            in = SimpleReaderUtils.openFile(this.parameters.getFile(), SimpleReaderStoreParameters.getCharset((DynObject)this.parameters));
            reader = this.getSimpleReader(in);
            AutomaticDetectionOfTypes x = new AutomaticDetectionOfTypes(fullFileName);
            types = x.detect(headers.length, reader, this.isFirstLineHeader(), SimpleReaderStoreParameters.getLocale((DynObject)this.parameters), status);
        }
        catch (Exception ex) {
            try {
                int lineno = 0;
                if (reader != null) {
                    lineno = reader.getLine();
                }
                throw new RuntimeException("Problems reading file '" + fullFileName + "' near line " + lineno + ".", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        IOUtils.closeQuietly((Reader)in);
        return types;
    }

    protected boolean isFirstLineHeader() {
        return false;
    }

    protected void fillFeatureType(EditableFeatureType fType, String[] headers, AutomaticDetectionOfTypes.DetectedValue[] automaticTypes) {
        fType.setHasOID(true);
        FieldTypeParser[] fieldTypes = this.getFieldTypes(headers, automaticTypes);
        this.fillFeatureType(fType, fieldTypes);
    }

    public boolean isAllFieldsDeclareType() {
        return this.all_fields_declare_type;
    }
}

