/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import java.io.File;
import java.io.IOException;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;

public abstract class SimpleReaderFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    protected FilesystemServerExplorerProviderServices serverExplorer;

    protected abstract String getFileExtension();

    @Override
    public int getMode() {
        return 3;
    }

    @Override
    public boolean accept(File file) {
        String pathname = file.getName().toLowerCase();
        return pathname.endsWith(this.getFileExtension());
    }

    @Override
    public boolean canCreate() {
        return false;
    }

    @Override
    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    @Override
    public void remove(DataStoreParameters parameters) throws RemoveException {
        SimpleReaderStoreParameters params = (SimpleReaderStoreParameters)parameters;
        File file = params.getFile();
        if (!file.exists()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new FileNotFoundException(params.getFile()));
        }
        if (!file.delete()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new IOException());
        }
    }

    @Override
    public boolean closeResourceRequested(ResourceProvider resource) {
        return !this.equals(resource);
    }

    @Override
    public void resourceChanged(ResourceProvider resource) {
    }

    protected EditableFeatureType fixFeatureType(FeatureType featureType) {
        EditableFeatureType newFeatureType = featureType instanceof EditableFeatureType ? (EditableFeatureType)featureType.getCopy() : featureType.getEditable();
        block6: for (int i = 0; i < newFeatureType.size(); ++i) {
            EditableFeatureAttributeDescriptor attr = (EditableFeatureAttributeDescriptor)newFeatureType.getAttributeDescriptor(i);
            switch (attr.getType()) {
                case 4: {
                    String s = String.valueOf(Integer.MAX_VALUE);
                    attr.setSize(18);
                    attr.setPrecision(0);
                    attr.setScale(0);
                    continue block6;
                }
                case 5: {
                    String s = String.valueOf(Long.MAX_VALUE);
                    attr.setSize(18);
                    attr.setPrecision(0);
                    attr.setScale(0);
                    continue block6;
                }
                case 6: {
                    attr.setSize(18);
                    attr.setPrecision(6);
                    attr.setScale(0);
                    continue block6;
                }
                case 7: {
                    attr.setSize(18);
                    attr.setPrecision(6);
                    attr.setScale(0);
                }
            }
        }
        return newFeatureType;
    }
}

