/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.arguments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class DefaultArguments
implements Arguments {
    private final Object[] args;
    protected Map<String, Object> flags;
    protected List<Object> parameters;

    public DefaultArguments(Object[] args) {
        this.args = args;
        this.flags = new HashMap<String, Object>();
        this.parameters = new ArrayList<Object>();
        this.parse();
    }

    private void parse() {
        boolean acceptFlags = true;
        String currentName = null;
        if (this.args == null) {
            return;
        }
        for (Object arg : this.args) {
            if (currentName != null) {
                this.flags.put(currentName.toLowerCase(), arg);
                currentName = null;
                continue;
            }
            if (acceptFlags) {
                if (arg.equals("--")) {
                    acceptFlags = false;
                    continue;
                }
                if (arg instanceof String) {
                    String strArg = Objects.toString(arg);
                    if (strArg.startsWith("--")) {
                        Object value;
                        String name;
                        int n = strArg.indexOf("=");
                        if (n < 0) {
                            name = strArg.substring(2);
                            value = true;
                            this.flags.put(name.toLowerCase(), value);
                            continue;
                        }
                        name = strArg.substring(2, n);
                        if (strArg.length() - 1 == n) {
                            currentName = name;
                            continue;
                        }
                        value = strArg.substring(n + 1);
                        this.flags.put(name.toLowerCase(), value);
                        continue;
                    }
                    this.parameters.add(arg);
                    continue;
                }
                this.parameters.add(arg);
                continue;
            }
            this.parameters.add(arg);
        }
    }

    @Override
    public Object get(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.flags.get(name.toLowerCase());
    }

    @Override
    public Object get(String name, Object defaultValue) {
        Object value = this.get(name);
        if (defaultValue == null) {
            return value;
        }
        if (value == null || StringUtils.isBlank((CharSequence)Objects.toString(value, null))) {
            return defaultValue;
        }
        if (defaultValue instanceof CharSequence) {
            return value;
        }
        if (defaultValue instanceof Integer) {
            return DataTypeUtils.toInteger(value, (Integer)defaultValue);
        }
        if (defaultValue instanceof Long) {
            return DataTypeUtils.toLong(value, (Long)defaultValue);
        }
        if (defaultValue instanceof Boolean) {
            try {
                return DataTypeUtils.toBoolean(value, (Boolean)defaultValue);
            }
            catch (Throwable th) {
                return BooleanUtils.toBoolean((String)Objects.toString(value));
            }
        }
        if (defaultValue instanceof Double) {
            return DataTypeUtils.toDouble(value, (Double)defaultValue);
        }
        if (defaultValue instanceof Float) {
            return DataTypeUtils.toDouble(value, ((Float)defaultValue).floatValue());
        }
        if (defaultValue instanceof Date) {
            return DataTypeUtils.toDate(value, (Date)defaultValue);
        }
        return value;
    }

    @Override
    public boolean contains(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        return this.flags.containsKey(name.toLowerCase());
    }

    @Override
    public boolean contains(String name, Object value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        Object x = this.flags.get(name.toLowerCase());
        if (x == null) {
            return false;
        }
        if (value instanceof String && x instanceof String) {
            return StringUtils.equalsIgnoreCase((CharSequence)((String)value), (CharSequence)((String)x));
        }
        if (value instanceof Boolean) {
            return value == DataTypeUtils.coerce(1, x, null);
        }
        return Objects.equals(value, x);
    }

    @Override
    public List<Object> parameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Map<String, Object> flags() {
        return Collections.unmodifiableMap(this.flags);
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public Object get(int n) {
        if (n >= this.parameters.size() || n < 0) {
            return null;
        }
        return this.parameters.get(n);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.parameters.iterator();
    }

    @Override
    public Object get(int n, Class elementClass, Object defaultValue) {
        if (n >= this.parameters.size() || n < 0) {
            return defaultValue;
        }
        Object o = this.parameters.get(n);
        if (elementClass.isInstance(o)) {
            return o;
        }
        return defaultValue;
    }

    @Override
    public List getListOf(int n, Class elementClass) {
        List list = (List)this.get(n, List.class, null);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (elementClass.isInstance(list.get(0))) {
            return list;
        }
        return null;
    }

    @Override
    public Object get(String name, Class elementClass, Object defaultValue) {
        Object o = this.flags.get(name.toLowerCase());
        if (elementClass.isInstance(o)) {
            return o;
        }
        return defaultValue;
    }

    @Override
    public List getListOf(String name, Class elementClass) {
        List list = (List)this.get(name, List.class, null);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (elementClass.isInstance(list.get(0))) {
            return list;
        }
        return null;
    }
}

