/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.bookmarksandhistory.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmark;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.BookmarksAndHistoryManager;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.bookmarksandhistory.impl.BaseBookmarks;
import org.gvsig.tools.bookmarksandhistory.impl.BaseHistory;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceTypeNotSupportedException;
import org.gvsig.tools.resourcesstorage.CompoundResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBookmarksAndHistoryManager
implements BookmarksAndHistoryManager {
    private final Map<String, Bookmarks> bookmarkGroups;
    private final Map<String, History> historyGroups;
    private ResourcesStorage primaryStorage;
    private ResourcesStorage secondaryStorage;
    private final int DEFAULT_VALUE_HISTORY_SIZE = 20;
    private final Logger LOGGER = LoggerFactory.getLogger(DefaultBookmarksAndHistoryManager.class);

    public DefaultBookmarksAndHistoryManager() {
        this.bookmarkGroups = new HashMap<String, Bookmarks>();
        this.historyGroups = new HashMap<String, History>();
    }

    @Override
    public boolean existsBookmarksGroup(String name) {
        return this.bookmarkGroups.containsKey(name);
    }

    @Override
    public boolean existsBookmarksHistory(String name) {
        return this.historyGroups.containsKey(name);
    }

    @Override
    public Collection<String> getBookmarkNames() {
        return this.bookmarkGroups.keySet();
    }

    @Override
    public Collection<String> getHistoryNames() {
        return this.historyGroups.keySet();
    }

    @Override
    public ResourcesStorage getPrimaryStorage() {
        return this.primaryStorage;
    }

    @Override
    public ResourcesStorage getSecondaryStorage() {
        return this.secondaryStorage;
    }

    @Override
    public void setPrimaryStorage(ResourcesStorage primaryStorage) {
        this.primaryStorage = primaryStorage;
    }

    @Override
    public void setSecondaryStorage(ResourcesStorage secondaryStorage) {
        this.secondaryStorage = secondaryStorage;
    }

    @Override
    public void registerBookmarksGroup(String name, Bookmarks bookmarks) {
        this.bookmarkGroups.put(name, bookmarks);
    }

    @Override
    public void registerBookmarksGroup(String name) {
        this.bookmarkGroups.put(name, new BaseBookmarks(name, new Supplier<ResourcesStorage>(){

            @Override
            public ResourcesStorage get() {
                return DefaultBookmarksAndHistoryManager.this.getBookmarksStorage();
            }
        }));
    }

    @Override
    public Bookmarks getBookmarksGroup(String name) {
        if (!this.existsBookmarksGroup(name)) {
            this.registerBookmarksGroup(name);
        }
        return this.bookmarkGroups.get(name);
    }

    @Override
    public void registerHistoryGroup(String name, History history) {
        this.historyGroups.put(name, history);
    }

    @Override
    public void registerHistoryGroup(String name, int size) {
        this.historyGroups.put(name, new BaseHistory(size));
    }

    @Override
    public History getHistoryGroup(String name) {
        if (!this.existsBookmarksHistory(name)) {
            this.registerHistoryGroup(name, 20);
        }
        return this.historyGroups.get(name);
    }

    @Override
    public void save() {
        if (this.primaryStorage != null) {
            this.saveHistory(this.primaryStorage);
        }
        if (this.secondaryStorage != null) {
            this.saveHistory(this.secondaryStorage);
        }
    }

    private ResourcesStorage getBookmarksStorage() {
        if (this.primaryStorage != null && this.secondaryStorage != null) {
            return new CompoundResourcesStorage(this.primaryStorage, this.secondaryStorage);
        }
        if (this.secondaryStorage != null) {
            return this.secondaryStorage;
        }
        if (this.primaryStorage != null) {
            return this.primaryStorage;
        }
        return null;
    }

    private void saveBookmarks(ResourcesStorage storage) {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        SimpleIdentityManager userManager = ToolsLocator.getIdentityManager();
        String userName = userManager.getCurrentIdentity().getID();
        HashSet<String> addedResources = new HashSet<String>();
        for (Map.Entry<String, Bookmarks> bookmarksEntry : this.bookmarkGroups.entrySet()) {
            String bookmarksGroupName = bookmarksEntry.getKey();
            Bookmarks bookmarks = bookmarksEntry.getValue();
            for (Bookmark bookmark : bookmarks) {
                String resourceName = bookmark.isGlobal() ? "ALL@BOOKMARKS!" + bookmarksGroupName + "!" + bookmark.getName() : userName + "@BOOKMARKS!" + bookmarksGroupName + "!" + bookmark.getName();
                try {
                    ResourcesStorage.Resource resource = storage.getResource(resourceName);
                    Throwable throwable = null;
                    try {
                        Object data = bookmark.getValue();
                        PersistentState state = persistenceManager.getState(data);
                        persistenceManager.saveState(state, resource.asOutputStream());
                        addedResources.add(resourceName);
                        this.LOGGER.info("save [" + resourceName + "]");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resource == null) continue;
                        if (throwable != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        resource.close();
                    }
                }
                catch (Exception ex) {
                    this.LOGGER.warn("Can't persist bookmark " + resourceName, (Throwable)ex);
                }
            }
        }
        if (storage.allowRemove() && !addedResources.isEmpty()) {
            for (String resourceName : storage.getResourceNames()) {
                if (!resourceName.contains(userName + "@BOOKMARKS!") || addedResources.contains(resourceName)) continue;
                storage.remove(resourceName);
                this.LOGGER.info("remove [" + resourceName + "]");
            }
        }
    }

    @Override
    public void load() {
        if (this.primaryStorage != null) {
            this.loadHistory(this.primaryStorage);
        }
        if (this.secondaryStorage != null) {
            this.loadHistory(this.secondaryStorage);
        }
    }

    private void loadBookmarks(ResourcesStorage storage) {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        SimpleIdentityManager userManager = ToolsLocator.getIdentityManager();
        String userName = userManager.getCurrentIdentity().getID();
        List<String> names = storage.getResourceNames();
        for (String name : names) {
            try {
                Bookmarks bookmarks;
                Object data2;
                Throwable throwable;
                ResourcesStorage.Resource resource;
                String[] userAndBookmark = StringUtils.split((String)name, (String)"@");
                String currentUserName = userAndBookmark[0];
                String[] groupAndId = StringUtils.split((String)userAndBookmark[1], (String)"!");
                if (groupAndId.length != 3) {
                    this.LOGGER.info("skip resource [" + name + "] BAD FORMAT");
                    continue;
                }
                String typeName = groupAndId[0];
                if (!StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"BOOKMARKS")) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"HISTORY")) continue;
                    this.LOGGER.info("skip resource [" + name + "] UNKNOWN TYPE");
                    continue;
                }
                String bookmarksGroupName = groupAndId[1];
                String bookmarkName = groupAndId[2];
                if (StringUtils.equalsIgnoreCase((CharSequence)currentUserName, (CharSequence)userName)) {
                    try {
                        resource = storage.getResource(name);
                        throwable = null;
                        try {
                            data2 = persistenceManager.getObject(resource.asInputStream());
                            bookmarks = this.getBookmarksGroup(bookmarksGroupName);
                            bookmarks.add(bookmarkName, data2);
                            this.LOGGER.info("load [" + name + "]");
                        }
                        catch (Throwable data2) {
                            throwable = data2;
                            throw data2;
                        }
                        finally {
                            if (resource == null) continue;
                            if (throwable != null) {
                                try {
                                    resource.close();
                                }
                                catch (Throwable data2) {
                                    throwable.addSuppressed(data2);
                                }
                                continue;
                            }
                            resource.close();
                        }
                    }
                    catch (Exception ex) {
                        this.LOGGER.warn("Can't load bookmark [" + name + "]", (Throwable)ex);
                    }
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)currentUserName, (CharSequence)"ALL")) continue;
                try {
                    resource = storage.getResource(name);
                    throwable = null;
                    try {
                        data2 = persistenceManager.getObject(resource.asInputStream());
                        bookmarks = this.getBookmarksGroup(bookmarksGroupName);
                        Bookmark bookmark = bookmarks.add(bookmarkName, data2);
                        bookmark.setGlobal(true);
                        this.LOGGER.info("load [" + name + "]");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resource == null) continue;
                        if (throwable != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        resource.close();
                    }
                }
                catch (Exception ex) {
                    this.LOGGER.warn("Can't load bookmark [" + name + "]", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                this.LOGGER.warn("Can't load bookmark(2) [" + name + "]", (Throwable)ex);
            }
        }
    }

    private void saveHistory(ResourcesStorage storage) {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        SimpleIdentityManager userManager = ToolsLocator.getIdentityManager();
        String userName = userManager.getCurrentIdentity().getID();
        for (Map.Entry<String, History> historyEntry : this.historyGroups.entrySet()) {
            String historyGroupName = historyEntry.getKey();
            History history = historyEntry.getValue();
            for (int i = 0; i < history.size(); ++i) {
                String resourceName = userName + "@HISTORY!" + historyGroupName + "!" + i;
                try (ResourcesStorage.Resource resource = storage.getResource(resourceName);){
                    Object data = history.get(i);
                    PersistentState state = persistenceManager.getState(data);
                    persistenceManager.saveState(state, resource.asOutputStream());
                    continue;
                }
                catch (PersistenceTypeNotSupportedException ex) {
                    this.LOGGER.info("Can't save history, persistence not supported (" + resourceName + ")");
                    continue;
                }
                catch (Exception ex) {
                    this.LOGGER.warn("Fail saving state from history record:" + resourceName, (Throwable)ex);
                }
            }
        }
    }

    private void loadHistory(ResourcesStorage storage) {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        SimpleIdentityManager userManager = ToolsLocator.getIdentityManager();
        String userName = userManager.getCurrentIdentity().getID();
        List<String> names = storage.getResourceNames();
        ArrayList<String> reversedList = new ArrayList<String>(names);
        Collections.sort(reversedList);
        Collections.reverse(reversedList);
        for (String name : reversedList) {
            try {
                String typeName;
                String[] userAndHistory = StringUtils.split((String)name, (String)"@");
                String currentUserName = userAndHistory[0];
                String[] groupAndId = StringUtils.split((String)userAndHistory[1], (String)"!");
                if (groupAndId.length != 3 || !StringUtils.equalsIgnoreCase((CharSequence)(typeName = groupAndId[0]), (CharSequence)"HISTORY")) continue;
                String groupName = groupAndId[1];
                if (!StringUtils.equalsIgnoreCase((CharSequence)currentUserName, (CharSequence)userName)) continue;
                try {
                    ResourcesStorage.Resource resource = storage.getResource(name);
                    Throwable throwable = null;
                    try {
                        Object data = persistenceManager.getObject(resource.asInputStream());
                        History history = this.getHistoryGroup(groupName);
                        history.add(data);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resource == null) continue;
                        if (throwable != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        resource.close();
                    }
                }
                catch (Exception ex) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.warn("Load history fail: " + name, (Throwable)ex);
                        continue;
                    }
                    this.LOGGER.warn("Load history fail: " + name + ". " + (ex.getCause() == null ? "" : ex.getCause().getMessage()));
                }
            }
            catch (Exception ex) {
                this.LOGGER.debug("Load history resources fail: " + name, (Throwable)ex);
            }
        }
    }

    @Override
    public void refresh() {
        for (Bookmarks group : this.bookmarkGroups.values()) {
            group.refresh();
        }
    }
}

