/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContextDecimal;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;

public class DataTypeUtils {
    private static CoercionContextLocale COERCE_CONTEXT_DEFAULT_LOCALE;
    private static CoercionContextDecimal COERCE_CONTEXT_DEFAULT_DECIMAL;

    protected DataTypeUtils() {
    }

    public static CoercionContextLocale coerceContextLocale(Locale locale) {
        return CoercionContextLocale.create(locale);
    }

    public static CoercionContextLocale coerceContextDefaultLocale() {
        if (COERCE_CONTEXT_DEFAULT_LOCALE == null || Locale.getDefault() != COERCE_CONTEXT_DEFAULT_LOCALE.locale()) {
            COERCE_CONTEXT_DEFAULT_LOCALE = CoercionContextLocale.create(Locale.getDefault());
        }
        return COERCE_CONTEXT_DEFAULT_LOCALE;
    }

    public static CoercionContextDecimal coerceContextDefaultDecimal() {
        if (COERCE_CONTEXT_DEFAULT_DECIMAL == null) {
            COERCE_CONTEXT_DEFAULT_DECIMAL = CoercionContextDecimal.create(Locale.ENGLISH);
        }
        return COERCE_CONTEXT_DEFAULT_DECIMAL;
    }

    public static CoercionContextDecimal coerceContextDecimal(Locale locale) {
        if (COERCE_CONTEXT_DEFAULT_DECIMAL != null && locale == COERCE_CONTEXT_DEFAULT_DECIMAL.locale()) {
            return COERCE_CONTEXT_DEFAULT_DECIMAL;
        }
        return CoercionContextDecimal.create(locale);
    }

    public static CoercionContextDecimal coerceContextDecimal(Locale locale, int precision, int scale, int roundMode) {
        return CoercionContextDecimal.create(locale, precision, scale, roundMode);
    }

    public static Coercion getCoercion(int type) {
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        DataType dataType = manager.get(type);
        Coercion c = dataType.getCoercion();
        return c;
    }

    public static Object coerce(int type, Object value, Object defaultValue) {
        Coercion coercer = DataTypeUtils.getCoercion(type);
        try {
            Object x = coercer.coerce(value);
            if (x == null) {
                return defaultValue;
            }
            return x;
        }
        catch (CoercionException ex) {
            return defaultValue;
        }
    }

    public static Object coerce(int type, Object value) throws CoercionException {
        Coercion c = DataTypeUtils.getCoercion(type);
        Object x = c.coerce(value);
        return x;
    }

    public static int toInteger(Object value, int defaultValue) {
        return (Integer)DataTypeUtils.coerce(4, value, defaultValue);
    }

    public static short toShort(Object value, short defaultValue) {
        try {
            return (Short)DataTypeUtils.coerce(4, value, defaultValue);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public static int toByte(Object value, byte defaultValue) {
        return (Integer)DataTypeUtils.coerce(2, value, defaultValue);
    }

    public static long toLong(Object value, long defaultValue) {
        return (Long)DataTypeUtils.coerce(5, value, defaultValue);
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Boolean)DataTypeUtils.coerce(1, value, defaultValue);
    }

    public static boolean isTrue(Object value, boolean defaultValue) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Boolean)DataTypeUtils.coerce(1, value, defaultValue);
    }

    public static boolean isFalse(Object value, boolean defaultValue) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        return (Boolean)DataTypeUtils.coerce(1, value, defaultValue) == false;
    }

    public static float toFloat(Object value, float defaultValue) {
        return ((Float)DataTypeUtils.coerce(6, value, Float.valueOf(defaultValue))).floatValue();
    }

    public static double toDouble(Object value, double defaultValue) {
        return (Double)DataTypeUtils.coerce(7, value, defaultValue);
    }

    public static String toString(Object value, String defaultValue) {
        return (String)DataTypeUtils.coerce(8, value, defaultValue);
    }

    public static String toString(Locale locale, Object value, String defaultValue) {
        Coercion coercer = DataTypeUtils.getCoercion(8);
        try {
            String x = (String)coercer.coerce(value, CoercionContextLocale.create(locale));
            if (x == null) {
                return defaultValue;
            }
            return x;
        }
        catch (CoercionException ex) {
            return defaultValue;
        }
    }

    public static java.util.Date toDate(Object value, java.util.Date defaultValue) {
        return (java.util.Date)DataTypeUtils.coerce(9, value, defaultValue);
    }

    public static java.util.Date toTime(Object value, java.util.Date defaultValue) {
        return (java.util.Date)DataTypeUtils.coerce(10, value, defaultValue);
    }

    public static java.util.Date toTimestamp(Object value, java.util.Date defaultValue) {
        return (java.util.Date)DataTypeUtils.coerce(11, value, defaultValue);
    }

    public static LocalDate toLocalDate(Object value) {
        java.util.Date d;
        if (value instanceof LocalDateTime) {
            return (LocalDate)value;
        }
        if (value instanceof TemporalAccessor) {
            try {
                return LocalDate.from((TemporalAccessor)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof java.util.Date) {
            d = (java.util.Date)value;
        } else {
            d = (java.util.Date)DataTypeUtils.coerce(11, value, null);
            if (d == null) {
                return null;
            }
        }
        return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate toLocalDate(java.util.Date value) {
        return DataTypeUtils.toLocalDate(Instant.ofEpochMilli(value.getTime()));
    }

    public static LocalDate toLocalDate(ChronoLocalDateTime value) {
        return DataTypeUtils.toLocalDate(value.atZone(ZoneId.systemDefault()));
    }

    public static LocalDate toLocalDate(ChronoLocalDate value) {
        return DataTypeUtils.toLocalDate(value.atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()));
    }

    public static LocalDate toLocalDate(LocalTime value) {
        return DataTypeUtils.toLocalDate(Instant.ofEpochSecond(value.toSecondOfDay(), value.getSecond()));
    }

    public static LocalDate toLocalDate(ChronoZonedDateTime value) {
        return DataTypeUtils.toLocalDate(value.toInstant());
    }

    public static LocalDate toLocalDate(Instant value) {
        return LocalDateTime.ofInstant(value, ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Object value) {
        java.util.Date d;
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof TemporalAccessor) {
            try {
                return LocalDateTime.from((TemporalAccessor)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof java.util.Date) {
            d = (java.util.Date)value;
        } else {
            d = (java.util.Date)DataTypeUtils.coerce(11, value, null);
            if (d == null) {
                return null;
            }
        }
        return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(java.util.Date value) {
        return DataTypeUtils.toLocalDateTime(Instant.ofEpochMilli(value.getTime()));
    }

    public static LocalDateTime toLocalDateTime(ChronoLocalDateTime value) {
        return DataTypeUtils.toLocalDateTime(value.atZone(ZoneId.systemDefault()));
    }

    public static LocalDateTime toLocalDateTime(ChronoLocalDate value) {
        return DataTypeUtils.toLocalDateTime(value.atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()));
    }

    public static LocalDateTime toLocalDateTime(LocalTime value) {
        return DataTypeUtils.toLocalDateTime(Instant.ofEpochSecond(value.toSecondOfDay(), value.getSecond()));
    }

    public static LocalDateTime toLocalDateTime(ChronoZonedDateTime value) {
        return DataTypeUtils.toLocalDateTime(value.toInstant());
    }

    public static LocalDateTime toLocalDateTime(Instant value) {
        return LocalDateTime.ofInstant(value, ZoneId.systemDefault());
    }

    public static LocalTime toLocalTime(Object value) {
        java.util.Date d;
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof TemporalAccessor) {
            try {
                return LocalTime.from((TemporalAccessor)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof java.util.Date) {
            d = (java.util.Date)value;
        } else {
            d = (java.util.Date)DataTypeUtils.coerce(11, value, null);
            if (d == null) {
                return null;
            }
        }
        return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalTime toLocalTime(java.util.Date value) {
        return DataTypeUtils.toLocalTime(Instant.ofEpochMilli(value.getTime()));
    }

    public static LocalTime toLocalTime(ChronoLocalDateTime value) {
        return DataTypeUtils.toLocalTime(value.atZone(ZoneId.systemDefault()));
    }

    public static LocalTime toLocalTime(ChronoLocalDate value) {
        return DataTypeUtils.toLocalTime(value.atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()));
    }

    public static LocalTime toLocalTime(LocalTime value) {
        return DataTypeUtils.toLocalTime(Instant.ofEpochSecond(value.toSecondOfDay(), value.getSecond()));
    }

    public static LocalTime toLocalTime(ChronoZonedDateTime value) {
        return DataTypeUtils.toLocalTime(value.toInstant());
    }

    public static LocalTime toLocalTime(Instant value) {
        return LocalDateTime.ofInstant(value, ZoneId.systemDefault()).toLocalTime();
    }

    public static String toString(Object value) {
        return (String)DataTypeUtils.coerce(8, value, null);
    }

    public static Date toDate(Object value) {
        if (value == null) {
            return null;
        }
        return (Date)DataTypeUtils.coerce(9, value, null);
    }

    public static Date toDate(ChronoLocalDateTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toDate(value.atZone(ZoneId.systemDefault()));
    }

    public static Date toDate(ChronoLocalDate value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toDate(value.atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()));
    }

    public static Date toDate(LocalTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toDate(Instant.ofEpochSecond(value.toSecondOfDay(), value.getSecond()));
    }

    public static Date toDate(ChronoZonedDateTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toDate(value.toInstant());
    }

    public static Date toDate(Instant value) {
        if (value == null) {
            return null;
        }
        return (Date)Date.from(value);
    }

    public static Time toTime(Object value) {
        if (value == null) {
            return null;
        }
        return (Time)DataTypeUtils.coerce(10, value, null);
    }

    public static Time toTime(ChronoLocalDateTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toTime(value.atZone(ZoneId.systemDefault()));
    }

    public static Time toTime(ChronoLocalDate value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toTime(value.atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()));
    }

    public static Time toTime(LocalTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toTime(Instant.ofEpochSecond(value.toSecondOfDay(), value.getSecond()));
    }

    public static Time toTime(ChronoZonedDateTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toTime(value.toInstant());
    }

    public static Time toTime(Instant value) {
        if (value == null) {
            return null;
        }
        return (Time)Time.from(value);
    }

    public static Timestamp toTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        return (Timestamp)DataTypeUtils.coerce(11, value, null);
    }

    public static Timestamp toTimestamp(java.util.Date value) {
        if (value == null) {
            return null;
        }
        return new Timestamp(value.getTime());
    }

    public static Timestamp toTimestamp(Timestamp value) {
        return value;
    }

    public static Timestamp toTimestamp(ChronoLocalDateTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toTimestamp(value.atZone(ZoneId.systemDefault()));
    }

    public static Timestamp toTimestamp(ChronoLocalDate value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toTimestamp(value.atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()));
    }

    public static Timestamp toTimestamp(LocalTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toTimestamp(Instant.ofEpochSecond(value.toSecondOfDay(), value.getSecond()));
    }

    public static Timestamp toTimestamp(ChronoZonedDateTime value) {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.toTimestamp(value.toInstant());
    }

    public static Timestamp toTimestamp(Instant value) {
        if (value == null) {
            return null;
        }
        return Timestamp.from(value);
    }

    public static float toFloat(Object value) {
        return ((Float)DataTypeUtils.coerce(6, value, Float.valueOf(Float.NaN))).floatValue();
    }

    public static double toDouble(Object value) {
        return (Double)DataTypeUtils.coerce(7, value, Double.NaN);
    }

    public static int toInteger(Object value) {
        return (Integer)DataTypeUtils.coerce(4, value, -1);
    }

    public static int toByte(Object value) {
        return (Integer)DataTypeUtils.coerce(2, value, -1);
    }

    public static short toShort(Object value) {
        try {
            return (Short)DataTypeUtils.coerce(4, value, -1);
        }
        catch (Throwable th) {
            return -1;
        }
    }

    public static long toLong(Object value) {
        return (Long)DataTypeUtils.coerce(5, value, -1);
    }

    public static boolean toBoolean(Object value) {
        return (Boolean)DataTypeUtils.coerce(1, value, false);
    }

    public static BigDecimal toBigDecimal(Object value, int precision, int scale, BigDecimal defaultValue) {
        CoercionContextDecimal context = CoercionContextDecimal.create(precision, scale);
        Coercion c = DataTypeUtils.getCoercion(19);
        try {
            BigDecimal x = (BigDecimal)c.coerce(value, context);
            if (x == null) {
                return defaultValue;
            }
            return x;
        }
        catch (CoercionException ex) {
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object value, int precision, int scale) {
        return DataTypeUtils.toBigDecimal(value, precision, scale, null);
    }

    public static byte[] toByteArray(Object value, byte[] defaultValue) {
        return (byte[])DataTypeUtils.coerce(12, value, defaultValue);
    }
}

