/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public abstract class AbstractCoerceToDate
extends AbstractCoercion {
    @Override
    public Object coerce(Object value) throws CoercionException {
        return this.coerce(value, DataTypeUtils.coerceContextDefaultLocale());
    }

    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return this.valueOf((Date)value);
        }
        Locale locale = null;
        if (context instanceof CoercionContextLocale) {
            locale = ((CoercionContextLocale)context).locale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return this.coerce(value, this.getFormatters(locale));
    }

    protected Object coerce(Object value, DateFormat[] formatters) throws CoercionException {
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String valueStr = value.toString();
        if (valueStr == null) {
            return null;
        }
        if ((valueStr = valueStr.trim()).length() == 0) {
            return null;
        }
        switch (valueStr.toLowerCase()) {
            case "now": {
                return this.now();
            }
            case "null": 
            case "none": {
                return null;
            }
        }
        try {
            Date d = this.valueOf(valueStr);
            if (d != null) {
                return d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (DateFormat formatter : formatters) {
            try {
                Date d = formatter.parse(valueStr);
                if (d == null) continue;
                return this.valueOf(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new CoercionException(this.getErrorMessage(formatters, valueStr));
    }

    private String getErrorMessage(DateFormat[] formatters, String value) throws CoercionException {
        StringBuilder builder = new StringBuilder();
        builder.append("The value to coerce (\"");
        builder.append(value);
        builder.append("\") has an invalid ");
        builder.append(this.getDateType());
        builder.append(" String format. The expected one is:");
        for (DateFormat formatter : formatters) {
            String formatDesc = formatter instanceof SimpleDateFormat ? ((SimpleDateFormat)formatter).toLocalizedPattern() : formatter.toString();
            builder.append(" '");
            builder.append(formatDesc);
            builder.append("'");
        }
        return builder.toString();
    }

    protected abstract DateFormat[] getFormatters(Locale var1);

    protected Date now() {
        Date d = this.valueOf(new Date());
        return d;
    }

    protected Date valueOf(String value) {
        try {
            Timestamp n = Timestamp.valueOf(value);
            return n;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Date valueOf(Date value) {
        return value;
    }

    protected abstract String getDateType();
}

