/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class CoerceToDouble
extends AbstractCoercion {
    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value == null || value instanceof Double) {
            return value;
        }
        return this.coerce(value, DataTypeUtils.coerceContextDefaultDecimal());
    }

    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null || value instanceof Double) {
            return value;
        }
        CoercionContextLocale theContext = context instanceof CoercionContextLocale ? (CoercionContextLocale)context : DataTypeUtils.coerceContextDefaultLocale();
        try {
            Double num;
            if (value instanceof Number) {
                num = ((Number)value).doubleValue();
            } else if (value instanceof Boolean) {
                num = (Boolean)value != false ? 1.0 : 0.0;
            } else if (value instanceof Date) {
                num = ((Date)value).getTime();
            } else {
                String s = value.toString();
                if (s == null) {
                    return null;
                }
                if ((s = s.trim().toLowerCase()).length() == 0) {
                    return null;
                }
                if (s.startsWith("0x")) {
                    num = Long.parseLong(s.substring(2), 16);
                } else {
                    Boolean bool = BooleanUtils.toBooleanObject((String)s);
                    if (bool != null) {
                        num = bool != false ? 1.0 : 0.0;
                    } else {
                        if (s.startsWith("+")) {
                            s = s.substring(1);
                        }
                        ParsePosition p = new ParsePosition(0);
                        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(theContext.locale());
                        Number n = nf.parse(s, p);
                        if (p.getErrorIndex() > 0 || p.getIndex() < s.length()) {
                            try {
                                n = Double.valueOf(s);
                            }
                            catch (NumberFormatException ex) {
                                throw new CoercionException("Can't coerce '" + s + "' to double with locale " + theContext.locale().getLanguage() + "(error index " + p.getErrorIndex() + ", index " + p.getIndex() + ").");
                            }
                        }
                        num = n.doubleValue();
                    }
                }
            }
            return num;
        }
        catch (CoercionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoercionException("Can't coerce '" + value.toString() + "' to double with locale " + theContext.locale().getLanguage() + "'.", e);
        }
    }

    public static void main(String[] args) throws CoercionException {
        CoerceToDouble toDouble = new CoerceToDouble();
        Double x = (double)((Double)toDouble.coerce("10.5"));
        System.out.println(x);
        x = (double)((Double)toDouble.coerce("123456789.5"));
        System.out.println(x);
        x = (double)((Double)toDouble.coerce("123,456,789.5"));
        System.out.println(x);
    }
}

