/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dispose.impl;

import java.util.concurrent.Callable;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.SupportDisposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisposableHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DisposableHelper.class);
    private final Object lock = new Object();
    private boolean disposed = false;

    public DisposableHelper(Disposable disposable) {
        if (ToolsLocator.getDisposableManager() != null) {
            ToolsLocator.getDisposableManager().bind(disposable);
        } else {
            LOG.warn("Can't retrieve the disposable manager,");
        }
    }

    public void dispose(SupportDisposable disposable) {
        this.dispose(disposable, () -> {
            disposable.doDispose();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(Disposable disposable, Callable doDispose) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.disposed && ToolsLocator.getDisposableManager().release(disposable)) {
                int code = -1;
                String label = null;
                try {
                    code = this.hashCode();
                    label = this.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOG.debug(String.format("Dispose object '%s' code =%x label='%s", this.getClass().getName(), code, label));
                try {
                    doDispose.call();
                }
                catch (Exception ex) {
                    LOG.error("Error performing dispose", (Throwable)ex);
                }
                this.disposed = true;
            }
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

