/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.exception;

import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;

public class DynFieldRequiredValueException
extends DynFieldValidateException {
    private static final long serialVersionUID = -7813629748228774775L;
    private static final String MESSAGE_FORMAT = "Field '%(fieldText)': Value required.";
    private static final String MESSAGE_KEY = "_Field_XfieldTextX_Value_required";

    public DynFieldRequiredValueException(DynField field, Object value) {
        super(MESSAGE_FORMAT, MESSAGE_KEY, -7813629748228774775L);
        this.setValue("field", field.getName());
        this.setValue("fieldText", this.translate(field.getName()));
        this.setValue(value);
    }

    private String translate(String name) {
        return ToolsLocator.getI18nManager().getTranslation(name);
    }

    private void setValue(Object value) {
        try {
            if (value instanceof DynObject) {
                this.setValue("value", ((DynObject)value).getDynClass().getName());
                return;
            }
            if (value instanceof DynClass) {
                this.setValue("value", ((DynClass)value).getName());
                return;
            }
            if (value instanceof DynStruct) {
                this.setValue("value", ((DynStruct)value).getName());
                return;
            }
            if (value == null) {
                this.setValue("value", "null");
            } else {
                this.setValue("value", value.toString());
            }
        }
        catch (Exception e) {
            this.setValue("value", "(unknow)");
        }
    }

    public DynField getDynField() {
        return (DynField)this.values().get("field");
    }

    public String getDynFieldName() {
        return this.getDynField().getName();
    }

    public Object getValueOfException() {
        return this.values().get("value");
    }
}

