/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.impl;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceTypeNotSupportedException;
import org.gvsig.tools.persistence.impl.exception.PersistenceIllegalStateTheClassNameNotSetException;
import org.gvsig.tools.persistence.impl.exception.PersistenceInvalidPropertyNameException;
import org.gvsig.tools.persistence.impl.exception.PersistenceInvalidTypeForPropertyException;
import org.gvsig.tools.persistence.impl.exception.PersistenceUnsuportedMapKeyTypeException;
import org.gvsig.tools.persistence.impl.exception.PersistenceValueNotFoundException;
import org.gvsig.tools.persistence.spi.PersistenceManagerServices;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.gvsig.tools.persistence.spi.PersistentIdentifier;
import org.gvsig.tools.persistence.spi.PersistentStateServices;
import org.gvsig.tools.util.FileTools;
import org.gvsig.tools.util.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentState
implements PersistentStateServices {
    private static final Logger logger = LoggerFactory.getLogger(PersistentState.class);
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("[\\w][\\d\\w_]*");
    private static final List validStdTypeClasses = Collections.unmodifiableList(Arrays.asList(Integer.class, Long.class, Float.class, Double.class, Boolean.class, String.class, Date.class, File.class, URL.class, URI.class, Byte.class));
    private Map values = new LinkedHashMap();
    private final PersistentContextServices context;
    private final PersistentIdentifier id;
    private final PersistenceManagerServices manager;
    private String theClassName = null;
    private PersistenceFactory factory;

    public AbstractPersistentState(PersistenceManagerServices manager, PersistentContextServices context, PersistentIdentifier id) {
        this.manager = manager;
        this.context = context;
        this.id = id;
        this.values = new HashMap();
    }

    @Override
    public void setFactory(PersistenceFactory factory) {
        this.factory = factory;
    }

    @Override
    public DynStruct getDefinition() {
        if (this.factory == null) {
            return null;
        }
        DynStruct definition = this.factory.getDefinition(this.theClassName);
        return definition;
    }

    private DynStruct getDefinitionCheckNull() {
        DynStruct definition = this.getDefinition();
        if (definition == null) {
            throw new NullPointerException("Can't locate definition for the class '" + this.theClassName + "' in the factory '" + this.factory.getClass().getName() + "', managed classes are '" + this.factory.getManagedClasses().toString() + "'.");
        }
        return definition;
    }

    @Override
    public Object get(String name) throws PersistenceException {
        Object ret = this.values.get(name);
        if (ret == null) {
            if (!this.values.containsKey(name) && !this.definitionHasField(name)) {
                throw new PersistenceValueNotFoundException(name);
            }
            return this.getDefaultValue(name);
        }
        return this.get(ret);
    }

    @Override
    public boolean isNull(String name) {
        Object ret = this.values.get(name);
        return ret == null;
    }

    @Override
    public List getList(String name) throws PersistenceException {
        return (List)this.get(name);
    }

    @Override
    public Map getMap(String name) throws PersistenceException {
        return (Map)this.get(name);
    }

    @Override
    public Set getSet(String name) throws PersistenceException {
        return (Set)this.get(name);
    }

    private Object get(Object obj) throws PersistenceException {
        if (obj instanceof PersistentContextServices.ObjectReference) {
            PersistentContextServices.ObjectReference ref = (PersistentContextServices.ObjectReference)obj;
            return ref.getObject();
        }
        if (obj instanceof Persistent) {
            return obj;
        }
        if (obj instanceof List && this.manager.getFactories().get(obj) == null) {
            ArrayList result = new ArrayList(((List)obj).size());
            this.getValues(result, ((List)obj).iterator());
            return result;
        }
        return obj;
    }

    private void getValues(List result, Iterator iterator) throws PersistenceException {
        while (iterator.hasNext()) {
            result.add(this.get(iterator.next()));
        }
    }

    @Override
    public boolean getBoolean(String name) throws PersistenceException {
        return (Boolean)this.get(name);
    }

    @Override
    public double getDouble(String name) throws PersistenceException {
        return ((Number)this.get(name)).doubleValue();
    }

    @Override
    public File getFile(String name) throws PersistenceException {
        Object obj = this.get(name);
        if (obj instanceof String) {
            return new File((String)obj);
        }
        return (File)obj;
    }

    @Override
    public URL getURL(String name) throws PersistenceException {
        Object obj = this.get(name);
        if (obj instanceof String) {
            try {
                return new URL((String)obj);
            }
            catch (MalformedURLException e) {
                throw new PersistenceException("Can't create URL from '" + (String)obj + "'", e);
            }
        }
        return (URL)obj;
    }

    @Override
    public URI getURI(String name) throws PersistenceException {
        Object obj = this.get(name);
        if (obj instanceof String) {
            try {
                return new URI((String)obj);
            }
            catch (URISyntaxException e) {
                throw new PersistenceException("Can't create URI from '" + (String)obj + "'", e);
            }
        }
        return (URI)obj;
    }

    @Override
    public Date getDate(String name) throws PersistenceException {
        return (Date)this.get(name);
    }

    @Override
    public float getFloat(String name) throws PersistenceException {
        return ((Number)this.get(name)).floatValue();
    }

    @Override
    public int getInt(String name) throws PersistenceException {
        return ((Number)this.get(name)).intValue();
    }

    @Override
    public Iterator getIterator(String name) throws PersistenceException {
        Collection collection = (Collection)this.get(name);
        if (collection == null) {
            return null;
        }
        return collection.iterator();
    }

    @Override
    public long getLong(String name) throws PersistenceException {
        return ((Number)this.get(name)).longValue();
    }

    @Override
    public Object[] getArray(String name, Class valueClass) throws PersistenceException {
        List valueList = this.getList(name);
        if (valueList == null) {
            return null;
        }
        Object array = Array.newInstance(valueClass, valueList.size());
        return valueList.toArray((Object[])array);
    }

    @Override
    public boolean[] getBooleanArray(String name) throws PersistenceException {
        List valueList = this.getList(name);
        if (valueList == null) {
            return null;
        }
        boolean[] theValues = new boolean[valueList.size()];
        for (int i = 0; i < theValues.length; ++i) {
            theValues[i] = (Boolean)valueList.get(i);
        }
        return theValues;
    }

    @Override
    public int[] getIntArray(String name) throws PersistenceException {
        List valueList = this.getList(name);
        if (valueList == null) {
            return null;
        }
        int[] theValues = new int[valueList.size()];
        for (int i = 0; i < theValues.length; ++i) {
            theValues[i] = ((Number)valueList.get(i)).intValue();
        }
        return theValues;
    }

    @Override
    public long[] getLongArray(String name) throws PersistenceException {
        List valueList = this.getList(name);
        if (valueList == null) {
            return null;
        }
        long[] theValues = new long[valueList.size()];
        for (int i = 0; i < theValues.length; ++i) {
            theValues[i] = ((Number)valueList.get(i)).longValue();
        }
        return theValues;
    }

    @Override
    public float[] getFloatArray(String name) throws PersistenceException {
        List valueList = this.getList(name);
        if (valueList == null) {
            return null;
        }
        float[] theValues = new float[valueList.size()];
        for (int i = 0; i < theValues.length; ++i) {
            theValues[i] = ((Number)valueList.get(i)).floatValue();
        }
        return theValues;
    }

    @Override
    public double[] getDoubleArray(String name) throws PersistenceException {
        List valueList = this.getList(name);
        if (valueList == null) {
            return null;
        }
        double[] theValues = new double[valueList.size()];
        for (int i = 0; i < theValues.length; ++i) {
            theValues[i] = ((Number)valueList.get(i)).doubleValue();
        }
        return theValues;
    }

    @Override
    public Date[] getDateArray(String name) throws PersistenceException {
        return (Date[])this.getArray(name, Date.class);
    }

    @Override
    public String[] getStringArray(String name) throws PersistenceException {
        return (String[])this.getArray(name, String.class);
    }

    @Override
    public Iterator getNames() {
        return this.values.keySet().iterator();
    }

    @Override
    public String getString(String name) throws PersistenceException {
        return (String)this.get(name);
    }

    @Override
    public void setNull(String name) throws PersistenceException {
        this.setValue(name, null);
    }

    @Override
    public void set(String name, String value) throws PersistenceException {
        this.setValue(name, value);
    }

    @Override
    public void set(String name, File value) throws PersistenceException {
        this.setValue(name, value);
    }

    @Override
    public void set(String name, URL value) throws PersistenceException {
        this.setValue(name, value);
    }

    @Override
    public void set(String name, URI value) throws PersistenceException {
        this.setValue(name, value);
    }

    @Override
    public void set(String name, int value) throws PersistenceException {
        this.setValue(name, value);
    }

    @Override
    public void set(String name, long value) throws PersistenceException {
        this.setValue(name, value);
    }

    @Override
    public void set(String name, double value) throws PersistenceException {
        this.setValue(name, value);
    }

    @Override
    public void set(String name, float value) throws PersistenceException {
        this.setValue(name, Float.valueOf(value));
    }

    @Override
    public void set(String name, boolean value) throws PersistenceException {
        this.setValue(name, value);
    }

    @Override
    public void set(String name, Persistent obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Object obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Map obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, List obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Iterator obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Object[] values) throws PersistenceException {
        this.set(name, values == null ? null : Arrays.asList(values));
    }

    @Override
    public void set(String name, Date[] values) throws PersistenceException {
        this.set(name, values == null ? null : Arrays.asList(values));
    }

    @Override
    public void set(String name, String[] values) throws PersistenceException {
        this.set(name, values == null ? null : Arrays.asList(values));
    }

    @Override
    public void set(String name, boolean[] value) throws PersistenceException {
        if (value == null) {
            this.setValue(name, null);
        } else {
            ArrayList<Boolean> valueList = new ArrayList<Boolean>(value.length);
            for (int i = 0; i < value.length; ++i) {
                valueList.add(value[i] ? Boolean.TRUE : Boolean.FALSE);
            }
            this.set(name, valueList);
        }
    }

    @Override
    public void set(String name, int[] value) throws PersistenceException {
        if (value == null) {
            this.setValue(name, null);
        } else {
            ArrayList<Integer> valueList = new ArrayList<Integer>(value.length);
            for (int i = 0; i < value.length; ++i) {
                valueList.add(value[i]);
            }
            this.set(name, valueList);
        }
    }

    @Override
    public void set(String name, long[] value) throws PersistenceException {
        if (value == null) {
            this.setValue(name, null);
        } else {
            ArrayList<Long> valueList = new ArrayList<Long>(value.length);
            for (int i = 0; i < value.length; ++i) {
                valueList.add(value[i]);
            }
            this.set(name, valueList);
        }
    }

    @Override
    public void set(String name, float[] value) throws PersistenceException {
        if (value == null) {
            this.setValue(name, null);
        } else {
            ArrayList<Float> valueList = new ArrayList<Float>(value.length);
            for (int i = 0; i < value.length; ++i) {
                valueList.add(Float.valueOf(value[i]));
            }
            this.set(name, valueList);
        }
    }

    @Override
    public void set(String name, double[] value) throws PersistenceException {
        if (value == null) {
            this.setValue(name, null);
        } else {
            ArrayList<Double> valueList = new ArrayList<Double>(value.length);
            for (int i = 0; i < value.length; ++i) {
                valueList.add(value[i]);
            }
            this.set(name, valueList);
        }
    }

    @Override
    public void set(String name, Set obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Boolean obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Integer obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Long obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Float obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Double obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    @Override
    public void set(String name, Date obj) throws PersistenceException {
        if (obj == null) {
            this.setNull(name);
        } else {
            this.setValue(name, this.getObjectToPersist(obj, name));
        }
    }

    protected Object getObjectToPersist(Object theOriginal) throws PersistenceException {
        return this.getObjectToPersist(theOriginal, null);
    }

    private Object getObjectToPersist(Object theOriginal, String propName) throws PersistenceException {
        DynField field = null;
        try {
            if (theOriginal == null) {
                return null;
            }
            if (validStdTypeClasses.contains(theOriginal.getClass())) {
                return theOriginal;
            }
            if (theOriginal instanceof File) {
                return new File(((File)theOriginal).toURI());
            }
            DynStruct definition = this.getDefinitionCheckNull();
            if (propName != null) {
                field = definition.getDynField(propName);
            }
            if (theOriginal instanceof Persistent) {
                PersistentContextServices.ObjectReference ref;
                if (field != null) {
                    Class classOfValue = field.getClassOfValue();
                    if (classOfValue == null) {
                        throw new NullPointerException("Class of value for field '" + definition.getFullName() + "' of '" + field.getName() + "' can't be null.");
                    }
                    if (!classOfValue.isAssignableFrom(theOriginal.getClass())) {
                        throw new PersistenceInvalidTypeForPropertyException(propName, definition, field, theOriginal);
                    }
                }
                if ((ref = this.context.get(theOriginal)) == null) {
                    PersistentStateServices state = this.manager.createState(theOriginal, this.context);
                    ref = this.context.get(state);
                }
                return ref;
            }
            if (this.manager.getFactories().get(theOriginal) != null) {
                PersistentContextServices.ObjectReference ref;
                if (field != null) {
                    Class classOfValue = field.getClassOfValue();
                    if (classOfValue == null) {
                        throw new NullPointerException("Class of value for field '" + definition.getFullName() + "' of '" + field.getName() + "' can't be null.");
                    }
                    if (!classOfValue.isAssignableFrom(theOriginal.getClass())) {
                        throw new PersistenceInvalidTypeForPropertyException(propName, definition, field, theOriginal);
                    }
                }
                if ((ref = this.context.get(theOriginal)) == null) {
                    PersistentStateServices state = this.manager.createState(theOriginal, this.context);
                    ref = this.context.get(state);
                }
                return ref;
            }
            if (theOriginal instanceof Map) {
                if (field != null && field.getType() != 36) {
                    throw new PersistenceInvalidTypeForPropertyException(propName, definition, field, theOriginal);
                }
                LinkedHashMap result = new LinkedHashMap(((Map)theOriginal).size());
                this.storeValues(result, (Map)theOriginal);
                return result;
            }
            if (theOriginal instanceof Set) {
                if (field != null && field.getType() != 35) {
                    throw new PersistenceInvalidTypeForPropertyException(propName, definition, field, theOriginal);
                }
                LinkedHashSet result = new LinkedHashSet(((Set)theOriginal).size());
                this.storeValues(result, ((Set)theOriginal).iterator());
                return result;
            }
            if (theOriginal instanceof List) {
                if (field != null && field.getType() != 34 && field.getType() != 33) {
                    throw new PersistenceInvalidTypeForPropertyException(propName, definition, field, theOriginal);
                }
                ArrayList result = new ArrayList(((List)theOriginal).size());
                this.storeValues(result, ((List)theOriginal).iterator());
                return result;
            }
            if (theOriginal instanceof Iterator) {
                if (field != null && field.getType() != 34 && field.getType() != 33) {
                    throw new PersistenceInvalidTypeForPropertyException(propName, definition, field, theOriginal);
                }
                ArrayList result = new ArrayList();
                this.storeValues(result, (Iterator)theOriginal);
                return result;
            }
            if (this.manager.getAutoValidation() == 3) {
                throw new PersistenceTypeNotSupportedException(theOriginal.getClass(), propName);
            }
            logger.error("Persistence type '" + theOriginal.getClass().getName() + "' not supported.");
            return null;
        }
        catch (PersistenceException ex) {
            PersistentContextServices theContext = (PersistentContextServices)this.getContext();
            if (!theContext.getCollectErrors()) {
                throw ex;
            }
            theContext.addError(ex);
            return null;
        }
        catch (Exception ex) {
            PersistentContextServices theContext = (PersistentContextServices)this.getContext();
            if (!theContext.getCollectErrors()) {
                throw new PersistenceException(ex);
            }
            theContext.addError(ex);
            return null;
        }
    }

    @Override
    public PersistentIdentifier getId() {
        return this.id;
    }

    @Override
    public void setValue(String name, Object value) throws PersistenceException {
        try {
            if (this.theClassName == null) {
                throw new PersistenceIllegalStateTheClassNameNotSetException();
            }
            if (!VALID_NAME_PATTERN.matcher(name).matches()) {
                throw new PersistenceInvalidPropertyNameException(name);
            }
            this.values.put(name, value);
        }
        catch (PersistenceException ex) {
            PersistentContextServices theContext = (PersistentContextServices)this.getContext();
            if (!theContext.getCollectErrors()) {
                throw ex;
            }
            theContext.addError(ex);
        }
        catch (Exception ex) {
            PersistentContextServices theContext = (PersistentContextServices)this.getContext();
            if (!theContext.getCollectErrors()) {
                throw new PersistenceException(ex);
            }
            theContext.addError(ex);
        }
    }

    @Override
    public String getTheClassName() {
        return this.theClassName;
    }

    @Override
    public void setTheClassName(String className) {
        this.theClassName = className;
    }

    private void storeValues(Collection storage, Iterator iter) throws PersistenceException {
        while (iter.hasNext()) {
            storage.add(this.getObjectToPersist(iter.next()));
        }
    }

    private void storeValues(Map storage, Map originalStorage) throws PersistenceException {
        for (Map.Entry orgEntry : originalStorage.entrySet()) {
            Object key = orgEntry.getKey();
            if (!(key == null || key instanceof String || key instanceof Number || key instanceof Boolean)) {
                if (key instanceof Persistent) {
                    key = this.getObjectToPersist(key);
                } else {
                    throw new PersistenceUnsuportedMapKeyTypeException(orgEntry.getKey().getClass());
                }
            }
            Object value = this.getObjectToPersist(orgEntry.getValue());
            storage.put(key, value);
        }
    }

    @Override
    public PersistentContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasValue(String name) {
        return this.values.containsKey(name);
    }

    @Override
    public Object getValue(String name) {
        return this.values.get(name);
    }

    private boolean definitionHasField(String name) {
        DynStruct definition = this.manager.getDefinition(this.getTheClassName());
        return definition != null && definition.getDynField(name) != null;
    }

    private Object getDefaultValue(String name) {
        DynStruct definition = this.manager.getDefinition(this.getTheClassName());
        if (definition == null) {
            return null;
        }
        if (definition.getDynField(name) == null) {
            return null;
        }
        DynField field = definition.getDynField(name);
        if (field instanceof DynField_v2) {
            return ((DynField_v2)field).getCoercedDefaultValue();
        }
        return field.getDefaultValue();
    }

    @Override
    public void relativizeFiles(File rootFolder) {
        PersistentContext theContext = this.getContext();
        URI cwd = new File(System.getProperty("user.dir")).toURI();
        Iterator statesIterator = theContext.iterator();
        while (statesIterator.hasNext()) {
            DynField[] fields;
            PersistentState aState = (PersistentState)statesIterator.next();
            DynStruct definition = aState.getDefinition();
            for (DynField field : fields = definition.getDynFields()) {
                File file;
                Serializable value;
                if (field.getType() == 13 || field.getType() == 14) {
                    try {
                        value = aState.getFile(field.getName());
                        if (!URLUtils.isDynamic((File)value)) {
                            value = FileTools.relativizeFile(rootFolder, (File)value);
                        }
                        aState.set(field.getName(), (File)value);
                    }
                    catch (PersistenceException e) {
                        logger.warn("Can't relativice field '" + field.getName() + "' for class '" + definition.getName() + "'.", (Throwable)e);
                    }
                    continue;
                }
                if (field.getType() == 16) {
                    try {
                        value = aState.getURL(field.getName());
                        if (URLUtils.isDynamic((URL)value)) continue;
                        if (value != null && "FILE".equalsIgnoreCase(((URL)value).getProtocol())) {
                            file = URLUtils.toFile((URL)value);
                            if (FileTools.isInDifferentDrive(rootFolder, file)) {
                                value = file.toURI().toURL();
                            } else {
                                file = FileTools.relativizeFile(rootFolder, file);
                                value = new URL("file", "", file.toURI().toString().substring(cwd.toString().length()));
                            }
                        }
                        aState.set(field.getName(), (URL)value);
                    }
                    catch (MalformedURLException | PersistenceException value2) {}
                    continue;
                }
                if (field.getType() != 17) continue;
                try {
                    value = aState.getURI(field.getName());
                    if (URLUtils.isDynamic((URI)value)) continue;
                    if (value != null && (((URI)value).getScheme() == null || "FILE".equalsIgnoreCase(((URI)value).getScheme()))) {
                        file = new File(((URI)value).getPath());
                        if (FileTools.isInDifferentDrive(rootFolder, file)) {
                            value = file.toURI();
                        } else {
                            file = FileTools.relativizeFile(rootFolder, file);
                            value = new URI(file.getPath().replace(File.separator, "/"));
                        }
                    }
                    aState.set(field.getName(), (URI)value);
                }
                catch (URISyntaxException | PersistenceException exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void derelativizeFiles(File rootFolder) {
        PersistentContext theContext = this.getContext();
        Iterator statesIterator = theContext.iterator();
        while (statesIterator.hasNext()) {
            String className;
            PersistentState aState = (PersistentState)statesIterator.next();
            if (aState == null) continue;
            try {
                className = aState.getTheClassName();
            }
            catch (Throwable e) {
                className = "Unknown";
            }
            try {
                DynField[] fields;
                DynStruct definition = aState.getDefinition();
                if (definition == null) continue;
                for (DynField field : fields = definition.getDynFields()) {
                    File file;
                    Serializable value;
                    if (field.getType() == 13 || field.getType() == 14) {
                        try {
                            value = aState.getFile(field.getName());
                            if (!URLUtils.isDynamic((File)value)) {
                                value = FileTools.derelativizeFile(rootFolder, (File)value);
                            }
                            aState.set(field.getName(), (File)value);
                        }
                        catch (PersistenceException e) {
                            logger.warn("Can't fix field '" + field.getName() + "' for class '" + definition.getName() + "'.", (Throwable)e);
                        }
                        continue;
                    }
                    if (field.getType() == 16) {
                        try {
                            value = aState.getURL(field.getName());
                            if (URLUtils.isDynamic((URL)value) || value == null || !"FILE".equalsIgnoreCase(((URL)value).getProtocol()) || ((URL)value).getFile().startsWith("/")) continue;
                            file = FileUtils.toFile((URL)value);
                            file = FileTools.derelativizeFile(rootFolder, file);
                            value = file.toURI().toURL();
                            aState.set(field.getName(), (URL)value);
                        }
                        catch (MalformedURLException | PersistenceException value2) {}
                        continue;
                    }
                    if (field.getType() != 17) continue;
                    try {
                        value = aState.getURI(field.getName());
                        if (URLUtils.isDynamic((URI)value) || value == null || ((URI)value).getScheme() != null && !"FILE".equalsIgnoreCase(((URI)value).getScheme()) || ((URI)value).isAbsolute() && ((URI)value).getPath().startsWith("/")) continue;
                        file = new File(((URI)value).getPath());
                        file = FileTools.derelativizeFile(rootFolder, file);
                        aState.set(field.getName(), file.toURI());
                    }
                    catch (PersistenceException persistenceException) {
                        // empty catch block
                    }
                }
            }
            catch (RuntimeException e) {
                String msg = "Can't fix relative paths in '" + className + "'";
                if (theContext.getCollectErrors()) {
                    theContext.addError(new RuntimeException(msg));
                }
                logger.info(msg, (Throwable)e);
            }
        }
    }

    @Override
    public int getInt(String name, int defaultValue) throws PersistenceException {
        try {
            return this.getInt(name);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    @Override
    public long getLong(String name, long defaultValue) throws PersistenceException {
        try {
            return this.getLong(name);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    @Override
    public double getDouble(String name, double defaultValue) throws PersistenceException {
        try {
            return this.getDouble(name);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(String name, float defaultValue) throws PersistenceException {
        try {
            return this.getFloat(name);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) throws PersistenceException {
        try {
            return this.getBoolean(name);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }
}

