/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.xml;

import java.io.InputStream;
import java.io.OutputStream;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceValidateExceptions;
import org.gvsig.tools.persistence.impl.AbstractPersistenceManager;
import org.gvsig.tools.persistence.impl.AbstractPersistentState;
import org.gvsig.tools.persistence.spi.PersistenceManagerServices;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.gvsig.tools.persistence.spi.PersistentIdentifier;
import org.gvsig.tools.persistence.spi.PersistentStateServices;
import org.gvsig.tools.persistence.xml.XMLPersistentStateReader;
import org.gvsig.tools.persistence.xml.XMLPersistentStateWriter;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLPersistenceManager
extends AbstractPersistenceManager {
    private static final String VERSION = "2.0.0";

    public XMLPersistenceManager() {
    }

    public XMLPersistenceManager(PersistenceManager.Factories factories) {
        super(factories);
    }

    @Override
    public PersistentStateServices createPersistentState(PersistentContextServices context, PersistentIdentifier id) {
        return new XMLPersistentState(this, context, id);
    }

    @Override
    public PersistentState loadState(InputStream in, PersistentContext context) throws PersistenceException {
        PersistentContextServices contextServices = (PersistentContextServices)context;
        XMLPersistentStateReader xmlReader = this.getReaderInstance();
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput(in, null);
        }
        catch (XmlPullParserException e) {
            throw new PersistenceException(e);
        }
        xmlReader.read(contextServices, (XmlPullParser)parser);
        return contextServices.getRoot().getState();
    }

    @Override
    public void saveState(PersistentState state, OutputStream out) throws PersistenceException, PersistenceValidateExceptions {
        this.saveState(state, out, false);
    }

    @Override
    public void saveState(PersistentState state, OutputStream out, boolean collectErrors) throws PersistenceException, PersistenceValidateExceptions {
        ((PersistentContextServices)state.getContext()).setCollectErrors(collectErrors);
        XMLPersistentStateWriter xmlWriter = this.getWriterInstance();
        xmlWriter.write((PersistentStateServices)state, out);
    }

    protected XMLPersistentStateReader getReaderInstance() {
        return new XMLPersistentStateReader(this);
    }

    protected XMLPersistentStateWriter getWriterInstance() {
        return new XMLPersistentStateWriter(this);
    }

    public String version() {
        return VERSION;
    }

    class XMLPersistentState
    extends AbstractPersistentState {
        XMLPersistentState(PersistenceManagerServices manager, PersistentContextServices context, PersistentIdentifier id) {
            super(manager, context, id);
        }
    }
}

