/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.xml;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceTypeNotSupportedException;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.gvsig.tools.persistence.spi.PersistentStateServices;
import org.gvsig.tools.persistence.xml.ChasetMap;
import org.gvsig.tools.persistence.xml.XMLPersistenceManager;
import org.gvsig.tools.persistence.xml.XMLPersistentConstants;

public class XMLPersistentStateWriter
implements XMLPersistentConstants {
    private static Method getCharSetMethod = null;
    private static Method getCharSetNameMethod = null;
    private XMLPersistenceManager manager;
    private PrintWriter print;
    private boolean useCsMap = false;
    private boolean useDomains = false;
    private static final Pattern DOT_PATTERN = Pattern.compile("[.]");
    private static final char UNIX_SEPARATOR = '/';
    private static final boolean UNIX_SYSTEM = File.separatorChar == '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public XMLPersistentStateWriter(XMLPersistenceManager persistenceManager) {
        this.manager = persistenceManager;
    }

    public void write(PersistentStateServices state, OutputStream out) throws PersistenceException {
        this.write(state, out, null);
    }

    public void write(PersistentStateServices state, OutputStream out, Map domains) throws PersistenceException {
        PersistentStateServices root = state;
        String rootId = root.getId().toString();
        PersistentContext context = state.getContext();
        OutputStreamWriter outWrite = new OutputStreamWriter(out);
        this.print = new PrintWriter(out);
        this.print.println(MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\"?>", this.getCharset(outWrite.getEncoding())));
        String rootAttributes = "";
        if (domains != null && domains.size() > 0) {
            this.useDomains = true;
            StringBuffer buffRootAttr = new StringBuffer();
            buffRootAttr.append('\n');
            buffRootAttr.append(MessageFormat.format("      xmlns:{0}=\"{1}\"", "tools", "http://www.gvsig.org/libTools"));
            for (Map.Entry entry : domains.entrySet()) {
                buffRootAttr.append('\n');
                buffRootAttr.append(MessageFormat.format("      xmlns:{0}=\"{1}\"", entry.getKey(), entry.getValue()));
            }
            Iterator iter = domains.entrySet().iterator();
            StringBuffer buffSchemas = new StringBuffer();
            buffSchemas.append('\n');
            buffSchemas.append(MessageFormat.format("{0} {1}.xsd \n", "tools", "http://www.gvsig.org/libTools"));
            while (iter.hasNext()) {
                Map.Entry entry;
                entry = iter.next();
                buffSchemas.append('\n');
                buffSchemas.append(MessageFormat.format("{0} {1}.xsd \n", entry.getValue(), entry.getKey()));
            }
            buffRootAttr.append('\n');
            buffRootAttr.append(MessageFormat.format("      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:SchemaLocation=\"{0}\"", buffSchemas.toString()));
            rootAttributes = buffRootAttr.toString();
        }
        this.print.println(MessageFormat.format("<{0}XMLPersitence xmlns:xlink=\"http://www.w3.org/1999/xlink\" {1}>", "", rootAttributes));
        this.print.println(MessageFormat.format("<persistence_xml_version>{0}</persistence_xml_version>", this.manager.version()));
        this.print.println(MessageFormat.format("  <rootState id_state=\"{0}\" xlink:type=\"simple\" xlink:href=\"states#id(''{0}'')\" />", rootId));
        Iterator itStates = context.iterator();
        this.print.println("<states>");
        while (itStates.hasNext()) {
            PersistentStateServices curState = (PersistentStateServices)itStates.next();
            try {
                this.writeState(curState);
            }
            catch (Exception ex) {
                if (context.getCollectErrors()) {
                    context.addError(ex);
                    continue;
                }
                throw ex;
            }
        }
        this.print.println("</states>");
        this.print.println(MessageFormat.format("</{0}XMLPersitence>", ""));
        this.print.flush();
    }

    private void writeState(PersistentStateServices curState) throws PersistenceException {
        Iterator itNames = curState.getNames();
        if (itNames == null || !itNames.hasNext()) {
            // empty if block
        }
        String theClassName = curState.getTheClassName();
        String tagName = XMLPersistentStateWriter.getXMLValidName(theClassName);
        DynStruct definition = curState.getDefinition();
        if (definition != null) {
            tagName = XMLPersistentStateWriter.getXMLValidName(curState.getDefinition().getFullName());
        }
        String domainName = "";
        if (this.useDomains) {
            PersistenceFactory factory = this.manager.getFactories().get(theClassName);
            domainName = factory.getDomainName() + ":";
        }
        this.print.println(MessageFormat.format("  <{0}{1} id=\"{2}\">", domainName, tagName, curState.getId()));
        while (itNames.hasNext()) {
            String name = (String)itNames.next();
            Object value = curState.getValue(name);
            StringBuffer strb = new StringBuffer();
            String type = this.transformValue(value, strb);
            boolean useNameAsTag = VALID_TAG_PATTERN.matcher(name).matches();
            String format = useNameAsTag ? "    <{0} type=\"{1}\">{2}</{0}>" : "    <value type=\"{1}\">\n      <name>{0}</name>\n      <data>{2}</data>\n    </value>";
            this.print.println(MessageFormat.format(format, name, type, strb.toString()));
        }
        this.print.println(MessageFormat.format("  </{0}{1}>", domainName, tagName, curState.getId()));
    }

    public static String getXMLValidName(String theClassName) {
        String name = theClassName;
        int pos = 0;
        while ((pos = name.indexOf(36)) > 0) {
            name = name.substring(0, pos).concat("..").concat(name.substring(pos + 1));
        }
        while ((pos = name.indexOf(58)) > 0) {
            name = name.substring(0, pos).concat("__").concat(name.substring(pos + 1));
        }
        return name;
    }

    private String transformValue(Object value, StringBuffer strb) throws PersistenceTypeNotSupportedException {
        if (value instanceof String) {
            return this.transformValue((String)value, strb);
        }
        if (value instanceof Number) {
            return this.transformValue((Number)value, strb);
        }
        if (value instanceof PersistentContextServices.ObjectReference) {
            return this.transformValue((PersistentContextServices.ObjectReference)value, strb);
        }
        if (value instanceof List) {
            return this.transformValue((List)value, strb);
        }
        if (value instanceof Set) {
            return this.transformValue((Set)value, strb);
        }
        if (value instanceof Map) {
            return this.transformValue((Map)value, strb);
        }
        if (value instanceof Boolean) {
            return this.transformValue((Boolean)value, strb);
        }
        if (value instanceof Date) {
            return this.transformValue((Date)value, strb);
        }
        if (value instanceof File) {
            return this.transformValue((File)value, strb);
        }
        if (value instanceof URL) {
            return this.transformValue((URL)value, strb);
        }
        if (value instanceof URI) {
            return this.transformValue((URI)value, strb);
        }
        if (value == null) {
            return this.transformNullValue(strb);
        }
        throw new PersistenceTypeNotSupportedException(value.getClass());
    }

    private String transformValue(String value, StringBuffer strb) {
        if (!VALID_VALUE_PATTERN.matcher(value).matches()) {
            strb.append("<![CDATA[");
            strb.append(value);
            strb.append("]]>");
        } else {
            strb.append(value);
        }
        return "string";
    }

    private String transformValue(File value, StringBuffer strb) {
        String data = value.getPath();
        if (!UNIX_SYSTEM) {
            data = data.replace('\\', '/');
        }
        if (!VALID_VALUE_PATTERN.matcher(data).matches()) {
            strb.append("<![CDATA[");
            strb.append(data);
            strb.append("]]>");
        } else {
            strb.append(data);
        }
        return "file";
    }

    private String transformValue(URL value, StringBuffer strb) {
        String data = value.toExternalForm();
        if (!VALID_VALUE_PATTERN.matcher(data).matches()) {
            strb.append("<![CDATA[");
            strb.append(data);
            strb.append("]]>");
        } else {
            strb.append(data);
        }
        return "url";
    }

    private String transformValue(URI value, StringBuffer strb) {
        String data = value.toASCIIString();
        if (!VALID_VALUE_PATTERN.matcher(data).matches()) {
            strb.append("<![CDATA[");
            strb.append(data);
            strb.append("]]>");
        } else {
            strb.append(data);
        }
        return "uri";
    }

    private String transformNullValue(StringBuffer strb) {
        return "null";
    }

    private String transformValue(Number value, StringBuffer strb) {
        strb.append(value);
        String[] classname = this.split(value.getClass().getName(), DOT_PATTERN);
        return classname[classname.length - 1].toLowerCase();
    }

    private String[] split(String txt, Pattern pattern) {
        return pattern.split(txt, 0);
    }

    private String transformValue(Boolean value, StringBuffer strb) {
        strb.append(value);
        return "boolean";
    }

    private String transformValue(Date value, StringBuffer strb) {
        strb.append(value.getTime());
        return "date";
    }

    private String transformValue(PersistentContextServices.ObjectReference value, StringBuffer strb) {
        strb.append(MessageFormat.format("\n        <reference id_state=\"{0}\" xlink:type=\"simple\" xlink:href=\"states#id(''{0}'')\" />", value.getId()));
        strb.append('\n');
        strb.append("    ");
        return "reference";
    }

    private String transformValue(List value, StringBuffer strb) throws PersistenceTypeNotSupportedException {
        Iterator iter = value.iterator();
        while (iter.hasNext()) {
            strb.append('\n');
            StringBuffer itemStrb = new StringBuffer();
            String type = this.transformValue(iter.next(), itemStrb);
            if ("reference".equalsIgnoreCase(type)) {
                strb.append(MessageFormat.format("      <item type=\"{0}\">{1}</item>", type, itemStrb.toString() + "  "));
                continue;
            }
            strb.append(MessageFormat.format("      <item type=\"{0}\">{1}</item>", type, itemStrb.toString()));
        }
        strb.append('\n');
        strb.append("    ");
        return "list";
    }

    private String transformValue(Set value, StringBuffer strb) throws PersistenceTypeNotSupportedException {
        Iterator iter = value.iterator();
        while (iter.hasNext()) {
            StringBuffer itemStrb = new StringBuffer();
            String type = this.transformValue(iter.next(), itemStrb);
            strb.append(MessageFormat.format("      <item type=\"{0}\">{1}</item>", type, itemStrb.toString()));
        }
        return "set";
    }

    private String transformValue(Map value, StringBuffer strb) throws PersistenceTypeNotSupportedException {
        for (Map.Entry entry : value.entrySet()) {
            StringBuffer keyStrb = new StringBuffer();
            String keyType = this.transformValue(entry.getKey(), keyStrb);
            StringBuffer valueStrb = new StringBuffer();
            String valueType = this.transformValue(entry.getValue(), valueStrb);
            strb.append(MessageFormat.format("\n      <mapitem>\n        <key type=\"{0}\">{1}</key>\n        <value type=\"{2}\">{3}</value>\n      </mapitem>\n", keyType, keyStrb.toString(), valueType, valueStrb.toString()));
        }
        return "map";
    }

    private String getCharsetByNio(String csName) {
        Object charSet;
        if (getCharSetNameMethod == null) {
            Class<?> charsetClass = null;
            try {
                charsetClass = Class.forName("java.nio.charset.Charset");
            }
            catch (ClassNotFoundException e) {
                this.useCsMap = true;
                return null;
            }
            try {
                getCharSetMethod = charsetClass.getMethod("forName", String.class);
            }
            catch (Exception e) {
                this.useCsMap = true;
                return null;
            }
            try {
                getCharSetNameMethod = charsetClass.getMethod("displayName", new Class[0]);
            }
            catch (Exception e) {
                this.useCsMap = true;
                return null;
            }
        }
        try {
            charSet = getCharSetMethod.invoke(null, csName);
        }
        catch (Exception e) {
            this.useCsMap = true;
            return null;
        }
        try {
            return (String)getCharSetNameMethod.invoke(charSet, new Object[0]);
        }
        catch (Exception e) {
            this.useCsMap = true;
            return null;
        }
    }

    private String getCharset(String csName) {
        String name;
        if (!this.useCsMap && (name = this.getCharsetByNio(csName)) != null) {
            return name;
        }
        return (String)ChasetMap.getMap().get(csName);
    }
}

