/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.resourcesstorage;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.resourcesstorage.BaseMultiResourcesStorage;
import org.gvsig.tools.resourcesstorage.BytesResource;
import org.gvsig.tools.resourcesstorage.EmptyResourcesStorage;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.MultiResourcesStorage;
import org.gvsig.tools.resourcesstorage.URLResource;

public interface ResourcesStorage
extends Disposable {
    public static final ResourcesStorage EMPTY_RESOURCESSTORAGE = new EmptyResourcesStorage();

    public static boolean isEmpty(ResourcesStorage res) {
        if (res == null) {
            return true;
        }
        return res.isEmpty();
    }

    public static ResourcesStorage createFilesResourcesStorage(String pathName) {
        return new FilesResourcesStorage(pathName);
    }

    public static ResourcesStorage createFilesResourcesStorage(List<String> fulllPathNames) {
        return new FilesResourcesStorage(fulllPathNames);
    }

    public static MultiResourcesStorage createMultiResourcesStorage() {
        return new BaseMultiResourcesStorage();
    }

    public static BytesResource createBytesResource(byte[] bytes) {
        return new BytesResource(bytes);
    }

    public static Resource createResource(String name, URL url) {
        try {
            return new URLResource(name, url);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Resource createResource(String name, URI uri) {
        try {
            return new URLResource(name, uri.toURL());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getSeparator();

    public Resource getResource(String var1);

    public List<Resource> getResources(String var1);

    public Resource getLocalizedResource(String var1);

    public List<Resource> getLocalizedResources(String var1);

    public boolean isEmpty();

    public boolean isReadOnly();

    public boolean exists(String var1);

    public boolean add(String var1, InputStream var2);

    public boolean remove(String var1);

    public boolean allowRemove();

    public List<String> getResourceNames();

    public void clearCache();

    public static interface Resource
    extends Closeable {
        public String getName();

        public boolean isReadOnly();

        public URL getURL();

        public boolean exists();

        public InputStream asInputStream() throws IOException;

        public OutputStream asOutputStream() throws IOException;

        @Override
        public void close();
    }
}

