/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.service;

import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.service.AbstractService;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.ProviderServices;

public abstract class AbstractPersistentService
extends AbstractService
implements Persistent {
    private static final String SERVICE_DYNCLASS_NAME = "Service";
    private static final String FIELD_PARAMETERS = "parameters";
    private static final String FIELD_PROVIDER_SERVICES = "provider-services";

    public AbstractPersistentService() {
        this.registerServicePersistence();
    }

    public AbstractPersistentService(DynObject serviceParameters) throws ServiceException {
        super(serviceParameters);
        this.registerServicePersistence();
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        DynObject serviceParameters = (DynObject)state.get(FIELD_PARAMETERS);
        ProviderServices providerServices = (ProviderServices)state.get(FIELD_PROVIDER_SERVICES);
        try {
            this.init(serviceParameters, providerServices);
        }
        catch (ServiceException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_PARAMETERS, this.getServiceParameters());
        state.set(FIELD_PROVIDER_SERVICES, this.getProviderServices());
    }

    private void registerServicePersistence() {
        DynClass childDynClass;
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        DynStruct dynClass = dynObjectManager.get(SERVICE_DYNCLASS_NAME);
        if (dynClass == null) {
            dynClass = this.createServiceDynClass(dynObjectManager);
        }
        if ((childDynClass = this.getServiceChildDynClass()) == null) {
            childDynClass = dynClass;
        } else {
            childDynClass.extend(dynClass);
        }
    }

    private DynStruct createServiceDynClass(DynObjectManager dynObjectManager) {
        PersistenceManager pmanager = ToolsLocator.getPersistenceManager();
        DynStruct definition = pmanager.addDefinition(this.getClass(), SERVICE_DYNCLASS_NAME, (String)null, null, null);
        definition.addDynFieldObject(FIELD_PARAMETERS).setMandatory(true);
        definition.addDynFieldObject(FIELD_PROVIDER_SERVICES).setMandatory(true);
        return definition;
    }

    protected abstract DynClass getServiceChildDynClass();

    protected abstract void doLoadFromState(PersistentState var1);

    protected abstract void doSaveToState(PersistentState var1);
}

