/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.undo.command.impl;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.tools.undo.RedoException;
import org.gvsig.tools.undo.UndoException;
import org.gvsig.tools.undo.command.Command;
import org.gvsig.tools.undo.command.impl.AbstractCommand;

public class CompoundCommand
extends AbstractCommand {
    private List commands = new ArrayList();

    public CompoundCommand(String description) {
        super(description);
    }

    public boolean isEmpty() {
        return this.commands.size() == 0;
    }

    @Override
    public void undo() throws UndoException {
        for (int i = this.commands.size() - 1; i >= 0; --i) {
            ((AbstractCommand)this.commands.get(i)).undo();
        }
    }

    @Override
    public void redo() throws RedoException {
        for (int i = 0; i < this.commands.size(); ++i) {
            ((AbstractCommand)this.commands.get(i)).redo();
        }
    }

    public void add(Command c) {
        this.commands.add(c);
    }

    @Override
    public int getType() {
        if (this.isEmpty()) {
            return 2;
        }
        int adds = this.getCount(1);
        int dels = this.getCount(0);
        if (adds > 0 && dels == 0) {
            return 1;
        }
        if (adds == 0 && dels > 0) {
            return 0;
        }
        return 2;
    }

    private int getCount(int ty) {
        if (this.commands == null || this.commands.size() == 0) {
            return 0;
        }
        int resp = 0;
        for (int i = 0; i < this.commands.size(); ++i) {
            if (((Command)this.commands.get(i)).getType() != ty) continue;
            ++resp;
        }
        return resp;
    }
}

