/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.Iterator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.util.ChainedIterator;

public class ChainedIterable<T>
implements DisposableIterable<T> {
    private final Iterable<T>[] iterables;

    public ChainedIterable(Iterable<T> ... iterables) {
        this.iterables = new Iterable[iterables.length];
        System.arraycopy(iterables, 0, this.iterables, 0, iterables.length);
    }

    @Override
    public Iterator<T> iterator() {
        Iterator[] iterators = new Iterator[this.iterables.length];
        for (int i = 0; i < this.iterables.length; ++i) {
            iterators[i] = this.iterables[i] == null ? null : this.iterables[i].iterator();
        }
        return new ChainedIterator(iterators);
    }

    @Override
    public void dispose() {
        for (Iterable<T> iterable : this.iterables) {
            if (!(iterable instanceof Disposable)) continue;
            ((Disposable)((Object)iterable)).dispose();
        }
    }
}

