/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.Iterator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;

public class ChainedIterator<T>
implements DisposableIterator<T> {
    private Iterator<T>[] iterators;
    private int current;

    public ChainedIterator(Iterator<T> ... iterators) {
        this.iterators = iterators;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.iterators == null) {
            return false;
        }
        while (this.current < this.iterators.length) {
            Iterator<T> it = this.iterators[this.current];
            if (it != null && it.hasNext()) {
                return true;
            }
            ++this.current;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.iterators == null) {
            return null;
        }
        Iterator<T> it = this.iterators[this.current];
        if (it == null) {
            return null;
        }
        return it.next();
    }

    @Override
    public void remove() {
        Iterator<T> it = this.iterators[this.current];
        if (it == null) {
            return;
        }
        it.remove();
    }

    @Override
    public void dispose() {
        if (this.iterators == null) {
            return;
        }
        for (Iterator<T> iterator : this.iterators) {
            DisposeUtils.dispose(iterator);
        }
        this.iterators = null;
        this.current = -1;
    }

    public int getCurrent() {
        return this.current;
    }
}

