/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;

public class CompareUtils {
    public static final Comparator EQUALS_IGNORECASE_COMPARATOR = new NullSafeComparator(){

        public int safeCompare(Object o1, Object o2) {
            return StringUtils.compareIgnoreCase((String)o1.toString(), (String)o2.toString());
        }
    };

    public static boolean equals(String str1, String str2) {
        return CompareUtils.compare(str1, str2, true) == 0;
    }

    public static int compare(Comparable c1, Comparable c2) {
        return CompareUtils.compare(c1, c2, true);
    }

    public static int compare(Comparator comparator, Object c1, Object c2) {
        return CompareUtils.compare(comparator, c1, c2, true);
    }

    public static int compare(Comparator comparator, Object c1, Object c2, boolean nullIsLess) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (c2 == null) {
            return nullIsLess ? 1 : -1;
        }
        if (comparator != null) {
            return comparator.compare(c1, c2);
        }
        if (c1 instanceof Comparable && c2 instanceof Comparable) {
            return ((Comparable)c1).compareTo((Comparable)c2);
        }
        return EQUALS_IGNORECASE_COMPARATOR.compare(c1, c2);
    }

    public static int compare(Comparable c1, Comparable c2, boolean nullIsLess) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (c2 == null) {
            return nullIsLess ? 1 : -1;
        }
        if (c1.getClass() == c2.getClass()) {
            return c1.compareTo(c2);
        }
        if (c1 instanceof CharSequence || c2 instanceof CharSequence) {
            return CompareUtils.compare(c1.toString(), c2.toString(), true);
        }
        if (c2 instanceof Number) {
            if (c1 instanceof Double) {
                return c1.compareTo(((Number)((Object)c2)).doubleValue());
            }
            if (c1 instanceof Float) {
                return c1.compareTo(Float.valueOf(((Number)((Object)c2)).floatValue()));
            }
            if (c1 instanceof BigDecimal) {
                if (c2 instanceof BigDecimal) {
                    return c1.compareTo(c2);
                }
                double value = ((Number)((Object)c2)).doubleValue();
                if (value == Double.NEGATIVE_INFINITY) {
                    return 1;
                }
                if (value == Double.POSITIVE_INFINITY) {
                    return -1;
                }
                return c1.compareTo(BigDecimal.valueOf(value));
            }
            if (c1 instanceof BigInteger) {
                if (c2 instanceof BigInteger) {
                    return c1.compareTo(c2);
                }
                long value = ((Number)((Object)c2)).longValue();
                return c1.compareTo(BigInteger.valueOf(value));
            }
            if (c1 instanceof Number) {
                if (c2 instanceof Double) {
                    return Double.valueOf(((Number)((Object)c1)).doubleValue()).compareTo((Double)c2);
                }
                if (c2 instanceof Float) {
                    return Float.valueOf(((Number)((Object)c1)).floatValue()).compareTo((Float)c2);
                }
                if (c2 instanceof BigDecimal) {
                    double value = ((Number)((Object)c1)).doubleValue();
                    if (value == Double.NEGATIVE_INFINITY) {
                        return -1;
                    }
                    if (value == Double.POSITIVE_INFINITY) {
                        return 1;
                    }
                    return BigDecimal.valueOf(value).compareTo((BigDecimal)c2);
                }
                if (c2 instanceof BigInteger) {
                    return BigInteger.valueOf(((Number)((Object)c1)).longValue()).compareTo((BigInteger)c2);
                }
                return Long.valueOf(((Number)((Object)c1)).longValue()).compareTo(((Number)((Object)c2)).longValue());
            }
        }
        return c1.compareTo(c2);
    }

    public static int compare(String str1, String str2) {
        return CompareUtils.compare(str1, str2, true);
    }

    public static int compare(String str1, String str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        str2 = StringUtils.stripAccents((String)str2);
        str1 = StringUtils.stripAccents((String)str1);
        return StringUtils.compareIgnoreCase((String)str1, (String)str2, (boolean)nullIsLess);
    }

    public static boolean match(Object value, String matcher) {
        if (value == null) {
            return false;
        }
        return CompareUtils.match(value.toString(), matcher);
    }

    public static boolean match(String value, String matcher) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)matcher)) {
            return true;
        }
        matcher = StringUtils.stripAccents((String)matcher);
        value = StringUtils.stripAccents((String)value);
        return FilenameUtils.wildcardMatch((String)value, (String)matcher, (IOCase)IOCase.INSENSITIVE);
    }

    public static boolean matchCaseSensitive(String value, String matcher) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)matcher)) {
            return true;
        }
        matcher = StringUtils.stripAccents((String)matcher);
        value = StringUtils.stripAccents((String)value);
        return FilenameUtils.wildcardMatch((String)value, (String)matcher, (IOCase)IOCase.SENSITIVE);
    }

    public static boolean matchAccentsSensitive(String value, String matcher) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)matcher)) {
            return true;
        }
        return FilenameUtils.wildcardMatch((String)value, (String)matcher, (IOCase)IOCase.INSENSITIVE);
    }

    public static boolean matchCaseAndAccentsSensitive(String value, String matcher) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)matcher)) {
            return true;
        }
        return FilenameUtils.wildcardMatch((String)value, (String)matcher, (IOCase)IOCase.SENSITIVE);
    }

    public static abstract class NullSafeComparator<T>
    implements Comparator<T> {
        private final boolean nullIsLess;

        public NullSafeComparator(boolean nullIsLess) {
            this.nullIsLess = nullIsLess;
        }

        public NullSafeComparator() {
            this(true);
        }

        @Override
        public final int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return this.nullIsLess ? -1 : 1;
            }
            if (o2 == null) {
                return this.nullIsLess ? 1 : -1;
            }
            return this.safeCompare(o1, o2);
        }

        public abstract int safeCompare(T var1, T var2);
    }
}

