/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.util.FolderSet;

public class DefaultFolderSet
extends BaseWeakReferencingObservable
implements FolderSet {
    private Set folders = new LinkedHashSet();
    private File defaultFolder = null;

    @Override
    public void add(File folder) {
        this.add(folder, null);
    }

    @Override
    public void add(File folder, String description) {
        if (folder == null) {
            return;
        }
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("folder required");
        }
        this.folders.add(new DefaultFolderEntry(folder, description));
        if (this.defaultFolder == null) {
            this.defaultFolder = folder;
        }
        this.notifyObservers();
    }

    @Override
    public void clear() {
        this.folders.clear();
        this.defaultFolder = null;
        this.notifyObservers();
    }

    @Override
    public void remove(File folder) {
        if (folder != null) {
            this.folders.remove(new DefaultFolderEntry(folder, null));
            if (folder.equals(this.defaultFolder)) {
                this.defaultFolder = null;
            }
            this.notifyObservers();
        }
    }

    @Override
    public void set(File folder) {
        this.beginComplexNotification();
        this.clear();
        this.setDefaultFolder(folder);
        this.endComplexNotification();
    }

    @Override
    public File[] listFiles() {
        ArrayList<File> entries = new ArrayList<File>();
        for (FolderSet.FolderEntry folderEntry : this.folders) {
            File[] files = folderEntry.getFolder().listFiles();
            if (files == null) continue;
            entries.addAll(Arrays.asList(files));
        }
        return entries.toArray(new File[entries.size()]);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        ArrayList<File> entries = new ArrayList<File>();
        for (FolderSet.FolderEntry folderEntry : this.folders) {
            File[] files = folderEntry.getFolder().listFiles(filter);
            if (files == null) continue;
            entries.addAll(Arrays.asList(files));
        }
        return entries.toArray(new File[entries.size()]);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        ArrayList<File> entries = new ArrayList<File>();
        for (FolderSet.FolderEntry folderEntry : this.folders) {
            File[] files = folderEntry.getFolder().listFiles(filter);
            if (files == null) continue;
            entries.addAll(Arrays.asList(files));
        }
        return entries.toArray(new File[entries.size()]);
    }

    @Override
    public Iterator iterator() {
        return this.folders.iterator();
    }

    @Override
    public void setDefaultFolder(File defaultFolder) {
        this.add(defaultFolder);
        this.defaultFolder = defaultFolder;
    }

    @Override
    public File getDefaultFolder() {
        Iterator it;
        if (this.defaultFolder == null && (it = this.folders.iterator()).hasNext()) {
            this.defaultFolder = (File)it.next();
        }
        return this.defaultFolder;
    }

    @Override
    public File asFile() {
        return this.getDefaultFolder();
    }

    @Override
    public String[] list() {
        ArrayList<String> entries = new ArrayList<String>();
        for (FolderSet.FolderEntry folderEntry : this.folders) {
            String[] files = folderEntry.getFolder().list();
            if (files == null) continue;
            entries.addAll(Arrays.asList(files));
        }
        return entries.toArray(new String[entries.size()]);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        ArrayList<String> entries = new ArrayList<String>();
        for (FolderSet.FolderEntry folderEntry : this.folders) {
            String[] files = folderEntry.getFolder().list(filter);
            if (files == null) continue;
            entries.addAll(Arrays.asList(files));
        }
        return entries.toArray(new String[entries.size()]);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public String getName() {
        return this.getDefaultFolder().getName();
    }

    @Override
    public String getParent() {
        return this.getDefaultFolder().getParent();
    }

    @Override
    public File getParentFile() {
        return this.getDefaultFolder().getParentFile();
    }

    @Override
    public String getPath() {
        return this.getDefaultFolder().getPath();
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this.getDefaultFolder().getCanonicalFile();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.getDefaultFolder().getCanonicalPath();
    }

    @Override
    public boolean canRead() {
        return this.getDefaultFolder().canRead();
    }

    @Override
    public boolean canWrite() {
        return this.getDefaultFolder().canWrite();
    }

    @Override
    public boolean exists() {
        return this.getDefaultFolder().exists();
    }

    @Override
    public File getAbsoluteFile() {
        return this.getDefaultFolder().getAbsoluteFile();
    }

    @Override
    public String getAbsolutePath() {
        return this.getDefaultFolder().getAbsolutePath();
    }

    public class DefaultFolderEntry
    implements FolderSet.FolderEntry {
        File folder;
        String label;

        DefaultFolderEntry(File folder, String label) {
            this.folder = folder;
            this.label = label;
        }

        public boolean equals(Object obj) {
            if (!(this.folder instanceof FolderSet.FolderEntry)) {
                return false;
            }
            return this.folder.equals(((FolderSet.FolderEntry)obj).getFolder());
        }

        public int hashCode() {
            return this.folder.hashCode();
        }

        @Override
        public File getFolder() {
            return this.folder;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }
}

