/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.compat;

import org.gvsig.compat.lang.GraphicsUtils;
import org.gvsig.compat.lang.MathUtils;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.compat.net.Downloader;
import org.gvsig.tools.locator.BaseLocator;
import org.gvsig.tools.locator.LocatorException;

public class CompatLocator
extends BaseLocator {
    public static final String STRINGUTILS_NAME = "StringUtils";
    public static final String MATHUTILS_NAME = "MathUtils";
    public static final String GRAPHICSUTILS_NAME = "GraphicsUtils";
    private static final String STRINGUTILS_DESCRIPTION = "Compatible implementation for String Utilities";
    private static final String MATHUTILS_DESCRIPTION = "Compatible implementation for Math Utilities";
    private static final String GRAPHICSUTILS_DESCRIPTION = "Compatible implementation for Graphics Utilities";
    public static final String DOWNLOADER_NAME = "Downloader";
    public static final String DOWNLOADER_DESCRIPTION = "Downloader descripction";
    private static final CompatLocator instance = new CompatLocator();

    public static CompatLocator getInstance() {
        return instance;
    }

    public static StringUtils getStringUtils() throws LocatorException {
        return (StringUtils)CompatLocator.getInstance().get(STRINGUTILS_NAME);
    }

    public static MathUtils getMathUtils() throws LocatorException {
        return (MathUtils)CompatLocator.getInstance().get(MATHUTILS_NAME);
    }

    public static void registerMathUtils(Class clazz) {
        CompatLocator.getInstance().register(MATHUTILS_NAME, MATHUTILS_DESCRIPTION, clazz);
    }

    public static void registerStringUtils(Class clazz) {
        CompatLocator.getInstance().register(STRINGUTILS_NAME, STRINGUTILS_DESCRIPTION, clazz);
    }

    public static GraphicsUtils getGraphicsUtils() throws LocatorException {
        return (GraphicsUtils)CompatLocator.getInstance().get(GRAPHICSUTILS_NAME);
    }

    public static void registerGraphicsUtils(Class clazz) {
        CompatLocator.getInstance().register(GRAPHICSUTILS_NAME, GRAPHICSUTILS_DESCRIPTION, clazz);
    }

    public static Downloader getDownloader() throws LocatorException {
        return (Downloader)CompatLocator.getInstance().get(DOWNLOADER_NAME);
    }

    public static void registerDownloader(Class clazz) {
        CompatLocator.getInstance().register(DOWNLOADER_NAME, DOWNLOADER_DESCRIPTION, clazz);
    }
}

