/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.rule;

import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.topology.lib.api.ExecuteTopologyRuleActionException;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyReportLine;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleAction;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.AbstractTopologyRule;
import org.gvsig.topology.lib.spi.AbstractTopologyRuleAction;

public class PolygonMustBeCoveredByPolygonRule
extends AbstractTopologyRule {
    private String geomName;
    private Expression expression = null;
    private GeometryExpressionBuilder expressionBuilder = null;

    public PolygonMustBeCoveredByPolygonRule() {
    }

    public PolygonMustBeCoveredByPolygonRule(TopologyRuleFactory factory, double tolerance, String dataSet1, String dataSet2) {
        super(factory, tolerance, dataSet1, dataSet2);
        this.addAction((TopologyRuleAction)new CreateFetureAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature1) throws Exception {
        Object set = null;
        try {
            FeatureStore store2 = this.getDataSet2().getFeatureStore();
            if (this.expression == null) {
                this.expression = ExpressionUtils.createExpression();
                this.expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                this.geomName = store2.getDefaultFeatureType().getDefaultGeometryAttributeName();
            }
            Geometry polygon = feature1.getDefaultGeometry();
            TopologyDataSet theDataSet2 = this.getDataSet2();
            double theTolerance = this.getTolerance();
            if (theDataSet2.getSpatialIndex() != null) {
                boolean contained = false;
                for (FeatureReference featureReference : theDataSet2.query(polygon)) {
                    Feature feature2 = featureReference.getFeature();
                    Geometry otherPolygon = feature2.getDefaultGeometry();
                    if (otherPolygon == null || !otherPolygon.buffer(theTolerance).contains(polygon)) continue;
                    contained = true;
                    break;
                }
                if (!contained) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), polygon, polygon, feature1.getReference(), null, false, i18n.getTranslation("_Polygon_is_not_covered_by_any_other_polygon"));
                }
            } else {
                if (theTolerance > 0.0) {
                    this.expression.setPhrase(this.expressionBuilder.ifnull((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)this.expressionBuilder.ST_Contains((ExpressionBuilder.Value)this.expressionBuilder.ST_Buffer((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)theTolerance)), (ExpressionBuilder.Value)this.expressionBuilder.geometry(polygon))).toString());
                } else {
                    this.expression.setPhrase(this.expressionBuilder.ifnull((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)this.expressionBuilder.ST_Contains((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.geometry(polygon))).toString());
                }
                if (theDataSet2.findFirst(this.expression) == null) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), polygon, polygon, feature1.getReference(), null, false, i18n.getTranslation("_Polygon_is_not_covered_by_any_other_polygon"));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check feature.", (Throwable)ex);
            this.addCodeException(report, feature1, ex);
        }
        finally {
            if (set != null) {
                set.dispose();
            }
        }
    }

    private class CreateFetureAction
    extends AbstractTopologyRuleAction {
        public CreateFetureAction() {
            super("PolygonContainsPoint", "CreateFeature", "Create Feature", "The Create Feature fix creates a new polygon feature out of the portion of overlap from the existing polygon so the boundary of each feature from both feature classes is the same. This fix can be applied to one or more selected Must Be Covered By errors.");
        }

        public int execute(TopologyRule rule, TopologyReportLine line, DynObject parameters) {
            try {
                Geometry polygon = line.getGeometry();
                TopologyDataSet dataSet = rule.getDataSet2();
                EditableFeature feature = dataSet.createNewFeature();
                feature.setDefaultGeometry(polygon);
                dataSet.insert(feature);
                return 0;
            }
            catch (Exception ex) {
                throw new ExecuteTopologyRuleActionException(ex);
            }
        }
    }
}

