/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.legend.driver;

import java.io.File;
import java.io.IOException;
import org.gvsig.fmap.mapcontext.exceptions.WriteLegendException;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.driver.ILegendWriter;
import org.gvsig.sldconverter.SLDConverterLocator;
import org.gvsig.sldconverter.SLDConverterManager;
import org.gvsig.sldsupport.SLDSupportLocator;
import org.gvsig.sldsupport.SLDSupportManager;
import org.gvsig.sldsupport.sld.SLDObject;
import org.gvsig.sldsupport.sld.SLDRoot;
import org.gvsig.sldsupport.sld.layer.SLDLayer;

public class LegendToSLDWriter
implements ILegendWriter {
    public void write(ILegend legend, File outFile, String format) throws WriteLegendException, IOException {
        SLDSupportManager sldSupMan = null;
        sldSupMan = SLDSupportLocator.getInstance().getSLDSupportManager();
        if (sldSupMan == null) {
            throw new WriteLegendException(legend, (Throwable)new Exception("No SLD support manager registered."));
        }
        SLDConverterManager sldConMan = null;
        sldConMan = SLDConverterLocator.getInstance().getSLDConverterManager();
        if (sldConMan == null) {
            throw new WriteLegendException(legend, (Throwable)new Exception("No SLD conversion manager registered."));
        }
        String fext = this.getFileExtension(format);
        if (fext.compareToIgnoreCase("sld") != 0) {
            throw new WriteLegendException(legend, (Throwable)new Exception("Unexpected format requested: " + format));
        }
        String fver = this.getFormatVersion(format);
        if (fver == null) {
            fver = "1.0.0";
        }
        SLDLayer lyr = null;
        try {
            lyr = sldConMan.toSLDLayer(legend);
        }
        catch (Exception e) {
            throw new WriteLegendException(legend, (Throwable)e);
        }
        if (lyr == null) {
            throw new WriteLegendException(legend, (Throwable)new Exception("Unable to convert to SLD layer"));
        }
        SLDRoot root = new SLDRoot(fver);
        root.getLayers().add(lyr);
        try {
            sldSupMan.write((SLDObject)root, fver, outFile);
        }
        catch (Exception e) {
            throw new WriteLegendException(legend, (Throwable)e);
        }
    }

    private String getFileExtension(String fmt) {
        if (fmt == null) {
            return null;
        }
        String[] parts = fmt.split(";");
        String aux = "";
        aux = parts.length > 1 ? parts[1].trim() : parts[0].trim();
        if ((parts = aux.split("=")).length > 1) {
            aux = parts[1].trim();
            return (parts = aux.split("/"))[0].length() == 0 ? null : parts[0];
        }
        aux = parts[0].trim();
        if ((parts = aux.split("/")).length > 1) {
            return parts[1].length() == 0 ? null : parts[1];
        }
        return aux.length() == 0 ? null : aux;
    }

    private String getFormatVersion(String fmt) {
        if (fmt == null) {
            return null;
        }
        String[] parts = fmt.split(";");
        String aux = "";
        if (parts.length <= 1) {
            return null;
        }
        aux = parts[1].trim();
        parts = aux.split("=");
        if (parts.length > 1) {
            aux = parts[1].trim();
            return (parts = aux.split("/"))[1].length() == 0 ? null : parts[1];
        }
        return null;
    }
}

