/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.app.ogr.mainplugin.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontrol.swing.dynobject.DynObjectEditor;
import org.gvsig.gdal.app.ogr.mainplugin.gui.JOGRDataExplorer;
import org.gvsig.gdal.app.ogr.mainplugin.gui.JOGRDataExplorerView;
import org.gvsig.gdal.app.ogr.mainplugin.gui.OGRDataStoreParameterTableModel;
import org.gvsig.gdal.prov.ogr.OGRDataExplorer;
import org.gvsig.gdal.prov.ogr.OGRDataExplorerParameters;
import org.gvsig.gdal.prov.ogr.OGRDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRDataStoreProviderFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JOGRDataExplorerController
extends JOGRDataExplorerView
implements JOGRDataExplorer {
    private static final Logger LOG = LoggerFactory.getLogger(JOGRDataExplorerController.class);
    private static final long serialVersionUID = 2347040531301288139L;
    private String lastConnectionString;
    private OGRDataExplorerParameters dataExplorerParameters;

    public JOGRDataExplorerController() {
        this.init();
    }

    private void init() {
        this.initFileChooserButton();
        this.initDataExplorerPropertiesButton();
        this.initOpenButton();
        this.initPropertiesButton();
        this.initLayerTable();
        this.translate();
    }

    private void initDataExplorerPropertiesButton() {
        this.dataExplorerPropertiesButton.setIcon(IconThemeHelper.getImageIcon((String)"ogr-dataexplorer-settings"));
        this.dataExplorerPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String connectionString = JOGRDataExplorerController.this.connectionField.getText();
                if (StringUtils.isBlank((String)connectionString)) {
                    JOGRDataExplorerController.this.lastConnectionString = null;
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(JOGRDataExplorerController.this, i18nManager.getTranslation("connection_string_can_not_be_empty"), i18nManager.getTranslation("error"), 0);
                    return;
                }
                if (!JOGRDataExplorerController.this.getConnectionString().equals(JOGRDataExplorerController.this.lastConnectionString)) {
                    JOGRDataExplorerController.this.setExplorerParameters();
                }
                try {
                    DynObjectEditor editor = new DynObjectEditor((DynObject)JOGRDataExplorerController.this.dataExplorerParameters);
                    editor.editObject(true);
                }
                catch (ServiceException e1) {
                    LOG.error(String.format("Can not create DynObjectEditor with %1s", JOGRDataExplorerController.this.dataExplorerParameters), (Object)e);
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(JOGRDataExplorerController.this, i18nManager.getTranslation("error_creating_properties_panel"), i18nManager.getTranslation("error"), 0);
                    return;
                }
            }
        });
    }

    private void setExplorerParameters() {
        File file;
        DataManager dataManager = DALLocator.getDataManager();
        List storeProviders = dataManager.getStoreProviders();
        for (String storeProviderName : storeProviders) {
            DataStoreProviderFactory factory;
            if (storeProviderName.equals("OGRDataStoreProvider") || !((factory = dataManager.getStoreProviderFactory(storeProviderName)) instanceof OGRDataStoreProviderFactory)) continue;
            OGRDataStoreProviderFactory ogrFactory = (OGRDataStoreProviderFactory)factory;
            DynObject explorerParameters = ogrFactory.createDataExplorerParameters((Object)this.getConnectionString());
            this.dataExplorerParameters = (OGRDataExplorerParameters)explorerParameters;
        }
        if (this.dataExplorerParameters == null) {
            OGRDataStoreProviderFactory factory = (OGRDataStoreProviderFactory)dataManager.getStoreProviderFactory("OGRDataStoreProvider");
            this.dataExplorerParameters = (OGRDataExplorerParameters)factory.createDataExplorerParameters((Object)this.getConnectionString());
        }
        if ((file = new File(this.getConnectionString())).exists() && file.isFile()) {
            this.dataExplorerParameters.setFile(file);
        } else {
            this.dataExplorerParameters.setConnectionString(this.getConnectionString());
        }
        this.lastConnectionString = this.getConnectionString();
    }

    private void initLayerTable() {
        this.layerTable.setSelectionMode(2);
        this.layerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (JOGRDataExplorerController.this.layerTable.getSelectedRowCount() == 1) {
                    JOGRDataExplorerController.this.propertiesButton.setEnabled(true);
                } else {
                    JOGRDataExplorerController.this.propertiesButton.setEnabled(false);
                }
            }
        });
    }

    private void initOpenButton() {
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List storeParametersList;
                File file;
                String connectionString = JOGRDataExplorerController.this.connectionField.getText();
                if (StringUtils.isBlank((String)connectionString)) {
                    JOGRDataExplorerController.this.lastConnectionString = null;
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(JOGRDataExplorerController.this, i18nManager.getTranslation("connection_string_can_not_be_empty"), i18nManager.getTranslation("error"), 0);
                    return;
                }
                DataManager dataManager = DALLocator.getDataManager();
                OGRDataExplorer serverExplorer = null;
                if (!JOGRDataExplorerController.this.getConnectionString().equals(JOGRDataExplorerController.this.lastConnectionString)) {
                    JOGRDataExplorerController.this.setExplorerParameters();
                }
                if (JOGRDataExplorerController.this.dataExplorerParameters == null) {
                    OGRDataStoreProviderFactory factory = (OGRDataStoreProviderFactory)dataManager.getStoreProviderFactory("OGRDataStoreProvider");
                    JOGRDataExplorerController.this.dataExplorerParameters = (OGRDataExplorerParameters)factory.createDataExplorerParameters((Object)connectionString);
                }
                if ((file = new File(connectionString)).exists() && file.isFile()) {
                    JOGRDataExplorerController.this.dataExplorerParameters.setFile(file);
                } else {
                    JOGRDataExplorerController.this.dataExplorerParameters.setConnectionString(connectionString);
                }
                JOGRDataExplorerController.this.lastConnectionString = connectionString;
                try {
                    serverExplorer = (OGRDataExplorer)dataManager.openServerExplorer(JOGRDataExplorerController.this.dataExplorerParameters.getExplorerName(), (DataServerExplorerParameters)JOGRDataExplorerController.this.dataExplorerParameters);
                }
                catch (InitializeException ex) {
                    LOG.error("Can not create OGR server explorer parameters", (Throwable)ex);
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(JOGRDataExplorerController.this, i18nManager.getTranslation("error_opening_connection_string"), i18nManager.getTranslation("error"), 0);
                    return;
                }
                catch (ProviderNotRegisteredException ex) {
                    LOG.error("OGR Provider is not registered", (Throwable)ex);
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(JOGRDataExplorerController.this, i18nManager.getTranslation("error_getting_OGR_provider"), i18nManager.getTranslation("error"), 0);
                    return;
                }
                catch (ValidateDataParametersException ex) {
                    LOG.error(String.format("Can not open OGR server explorer. Parameters: %1s", connectionString), (Throwable)ex);
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(JOGRDataExplorerController.this, i18nManager.getTranslation("error_opening_connection_string"), i18nManager.getTranslation("error"), 0);
                    return;
                }
                try {
                    storeParametersList = serverExplorer.list();
                }
                catch (DataException ex) {
                    LOG.error("Can not get layer list of OGR Data Explorer", (Throwable)ex);
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(JOGRDataExplorerController.this, i18nManager.getTranslation("error_getting_layers_from_connection_string"), i18nManager.getTranslation("error"), 0);
                    return;
                }
                JOGRDataExplorerController.this.layerTable.setModel(new OGRDataStoreParameterTableModel(storeParametersList));
            }
        });
    }

    private void initPropertiesButton() {
        this.propertiesButton.setEnabled(false);
        this.propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OGRDataStoreParameterTableModel model = (OGRDataStoreParameterTableModel)JOGRDataExplorerController.this.layerTable.getModel();
                OGRDataStoreParameters parameters = model.getDataStoreParameter(JOGRDataExplorerController.this.layerTable.getSelectedRow());
                try {
                    DynObjectEditor editor = new DynObjectEditor((DynObject)parameters);
                    editor.editObject(true);
                }
                catch (ServiceException e) {
                    LOG.error(String.format("Can not create DynObjectEditor with %1s", parameters), (Throwable)e);
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    JOptionPane.showMessageDialog(JOGRDataExplorerController.this, i18nManager.getTranslation("error_creating_properties_panel"), i18nManager.getTranslation("error"), 0);
                    return;
                }
            }
        });
    }

    private void initFileChooserButton() {
        this.fileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                int reply;
                File file2;
                FoldersManager foldersManager = ToolsLocator.getFoldersManager();
                FileDialogChooserManager fileDialogChooserManager = ToolsUtilLocator.getFileDialogChooserManager();
                FileDialogChooser chooser = fileDialogChooserManager.create("OPEN_LAYER_FILE_CHOOSER_ID");
                chooser.setCurrentDirectory(foldersManager.get("DataFolder"));
                if (StringUtils.isNotBlank((String)JOGRDataExplorerController.this.getConnectionString()) && (file2 = new File(JOGRDataExplorerController.this.getConnectionString())).exists()) {
                    chooser.setCurrentDirectory(file2.getParentFile());
                }
                if ((reply = chooser.showOpenDialog((Component)JOGRDataExplorerController.this.asJComponent())) == 0 && (file = chooser.getSelectedFile()).isFile() && file.exists() && file.canRead()) {
                    JOGRDataExplorerController.this.connectionField.setText(file.getAbsolutePath());
                }
            }
        });
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public void setLocale(Locale l) {
        if (!this.getLocale().equals(l)) {
            this.translate();
        }
        super.setLocale(l);
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.connectionLabel.setText(i18nManager.getTranslation(this.connectionLabel.getText()));
        this.openButton.setText(i18nManager.getTranslation(this.openButton.getText()));
        this.propertiesButton.setText(i18nManager.getTranslation(this.propertiesButton.getText()));
    }

    @Override
    public List<String> getSelectedLayerNames() {
        ArrayList<String> selectedLayerNames = new ArrayList<String>();
        OGRDataStoreParameterTableModel model = this.getOGRTableModel();
        int[] selectedRows = this.layerTable.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            OGRDataStoreParameters dataStoreParameter = model.getDataStoreParameter(selectedRows[i]);
            selectedLayerNames.add(dataStoreParameter.getLayerName());
        }
        return selectedLayerNames;
    }

    @Override
    public List<DataStoreParameters> getSelectedLayerProperties() throws InitializeException, ProviderNotRegisteredException {
        OGRDataStoreParameterTableModel model = this.getOGRTableModel();
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        int[] selectedRows = this.layerTable.getSelectedRows();
        ArrayList<DataStoreParameters> parameters = new ArrayList<DataStoreParameters>();
        for (int i = 0; i < selectedRows.length; ++i) {
            parameters.add((DataStoreParameters)model.getDataStoreParameter(selectedRows[i]));
        }
        return parameters;
    }

    @Override
    public List<Integer> getSelectedLayerIndexes() {
        int[] selectedRows = this.layerTable.getSelectedRows();
        return Arrays.asList(ArrayUtils.toObject((int[])selectedRows));
    }

    @Override
    public String getConnectionString() {
        return this.connectionField.getText();
    }

    private OGRDataStoreParameterTableModel getOGRTableModel() {
        TableModel model = this.layerTable.getModel();
        if (model instanceof OGRDataStoreParameterTableModel) {
            return (OGRDataStoreParameterTableModel)model;
        }
        return null;
    }
}

